/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;

public final class NaturalLanguageTemplateGenTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<ns2:naturalLanguageTemplate xmlns:ns2=\"http://rice.kuali.org/krms/v2_0\" xmlns=\"http://rice.kuali.org/core/v2_0\">\n    <ns2:attributes/>\n    <ns2:languageCode>NL</ns2:languageCode>\n    <ns2:naturalLanguageUsageId>NATURAL_LANGUAGE_USAGE_ID</ns2:naturalLanguageUsageId>\n    <ns2:typeId>TYPE_ID</ns2:typeId>\n    <ns2:template>TEMPLATE</ns2:template>\n    <ns2:id>ID</ns2:id>\n    <ns2:active>false</ns2:active>\n</ns2:naturalLanguageTemplate>";
    private static final boolean ACTIVE = false;
    private static final String ID = "ID";
    private static final String LANGUAGE_CODE = "NL";
    private static final String NATURAL_LANGUAGE_USAGE_ID = "NATURAL_LANGUAGE_USAGE_ID";
    private static final String TEMPLATE = "TEMPLATE";
    private static final String TYPE_ID = "TYPE_ID";
    private static final Long VERSION_NUMBER = 0L;

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_Builder_create_fail_all_null() {
        NaturalLanguageTemplate.Builder.create(null, null, null, null);
    }

    @Test
    public void test_NaturalLanguageTemplate_set_validation_id_success_null() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_id_fail_empty() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_id_fail_whitespace() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setId("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_language_fail_null() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setLanguageCode(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_language_fail_empty() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setLanguageCode("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_language_fail_whitespace() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setLanguageCode("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_naturalLanguageUsageId_fail_null() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setNaturalLanguageUsageId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_naturalLanguageUsageId_fail_empty() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setNaturalLanguageUsageId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_naturalLanguageUsageId_fail_whitespace() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setNaturalLanguageUsageId("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_template_fail_null() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setTemplate(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_template_fail_empty() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setTemplate("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_template_fail_whitespace() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setTemplate("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_typeId_fail_null() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setTypeId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_typeId_fail_empty() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setTypeId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageTemplate_set_validation_typeId_fail_whitespace() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setTypeId("    ");
    }

    @Test
    public void test_NaturalLanguageTemplate_Builder_create() {
        NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
    }

    @Test
    public void test_NaturalLanguageTemplate_Builder_create_and_build() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.build();
    }

    @Test
    public void test_NaturalLanguageTemplate_xml_marshaling() throws Exception {
        NaturalLanguageTemplate naturalLanguageTemplate = NaturalLanguageTemplateGenTest.buildFullNaturalLanguageTemplate();
        this.assertXmlMarshaling(naturalLanguageTemplate, XML);
    }

    public void assertXmlMarshaling(Object naturalLanguageTemplate, String expectedXml) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{NaturalLanguageTemplate.class});
        Marshaller marshaller = jc.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(naturalLanguageTemplate, (Writer)stringWriter);
        String xml = stringWriter.toString();
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object actual = unmarshaller.unmarshal((Reader)new StringReader(xml));
        Object expected = unmarshaller.unmarshal((Reader)new StringReader(expectedXml));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static NaturalLanguageTemplate buildFullNaturalLanguageTemplate() {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)NATURAL_LANGUAGE_USAGE_ID, (String)TEMPLATE, (String)TYPE_ID);
        builder.setId(ID);
        NaturalLanguageTemplate naturalLanguageTemplate = builder.build();
        return naturalLanguageTemplate;
    }

    public static NaturalLanguageTemplate buildFullNaturalLanguageTemplate(NaturalLanguageUsage depDef, KrmsTypeDefinition typeDef) {
        NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((String)LANGUAGE_CODE, (String)depDef.getId(), (String)TEMPLATE, (String)typeDef.getId());
        builder.setId(ID);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(TEMPLATE, "template");
        builder.setAttributes(attributes);
        NaturalLanguageTemplate naturalLanguageTemplate = builder.build();
        return naturalLanguageTemplate;
    }
}

