/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolutionEngine;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.engine.BasicExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.ComparableTermBasedProposition;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.TermResolutionEngineImpl;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperatorServiceImpl;
import org.kuali.rice.krms.framework.type.ValidationRuleType;
import org.kuali.rice.krms.impl.validation.ValidationRule;

public class ValidationRuleTest {
    Term term = new Term("true");
    final SelectionCriteria testEvent = SelectionCriteria.createCriteria((DateTime)new DateTime(), (Map)Collections.EMPTY_MAP, Collections.singletonMap("Event", "testEvent"));
    Map<Term, Object> facts = new HashMap<Term, Object>();
    TermResolutionEngine termResolutionEngine = new TermResolutionEngineImpl();
    ExecutionOptions executionOptions = new ExecutionOptions().setFlag(ExecutionFlag.LOG_EXECUTION, true);
    private ActionMock actionMock;
    private ComparisonOperator operatorEquals;

    @Before
    public void setUp() {
        this.operatorEquals = ComparisonOperator.EQUALS;
        this.operatorEquals.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        this.actionMock = new ActionMock("a1");
        this.actionMock.resetActionsFired();
        this.facts.put(this.term, "true");
    }

    @Test
    public void testValidRulePassesActionDoesntFire() {
        ValidationRule validationRule = new ValidationRule(ValidationRuleType.VALID, "testValidRulePassesActionDoesntFire", (Proposition)new ComparableTermBasedProposition(this.operatorEquals, this.term, (Object)"true"), Collections.singletonList(this.actionMock));
        Assert.assertTrue((boolean)validationRule.evaluate((ExecutionEnvironment)new BasicExecutionEnvironment(this.testEvent, this.facts, this.executionOptions, this.termResolutionEngine)));
        Assert.assertFalse((boolean)this.actionMock.actionFired("a1"));
    }

    @Test
    public void testValidRuleFailsActionFires() {
        ValidationRule validationRule = new ValidationRule(ValidationRuleType.VALID, "testValidRuleFailsActionFires", (Proposition)new ComparableTermBasedProposition(this.operatorEquals, this.term, (Object)"false"), Collections.singletonList(this.actionMock));
        Assert.assertFalse((boolean)validationRule.evaluate((ExecutionEnvironment)new BasicExecutionEnvironment(this.testEvent, this.facts, this.executionOptions, this.termResolutionEngine)));
        Assert.assertTrue((boolean)this.actionMock.actionFired("a1"));
    }

    @Test
    public void testInvalidRulePassesActionFires() {
        ValidationRule validationRule = new ValidationRule(ValidationRuleType.INVALID, "testInvalidRulePassesActionFires", (Proposition)new ComparableTermBasedProposition(this.operatorEquals, this.term, (Object)"true"), Collections.singletonList(this.actionMock));
        Assert.assertTrue((boolean)validationRule.evaluate((ExecutionEnvironment)new BasicExecutionEnvironment(this.testEvent, this.facts, this.executionOptions, this.termResolutionEngine)));
        Assert.assertTrue((boolean)this.actionMock.actionFired("a1"));
    }

    @Test
    public void testInvalidRuleFalseActionDoesntFire() {
        ValidationRule validationRule = new ValidationRule(ValidationRuleType.INVALID, "testInvalidRuleFalseActionDoesntFire", (Proposition)new ComparableTermBasedProposition(this.operatorEquals, this.term, (Object)"false"), Collections.singletonList(this.actionMock));
        Assert.assertFalse((boolean)validationRule.evaluate((ExecutionEnvironment)new BasicExecutionEnvironment(this.testEvent, this.facts, this.executionOptions, this.termResolutionEngine)));
        Assert.assertFalse((boolean)this.actionMock.actionFired("a1"));
    }

    private class ActionMock
    implements Action {
        private final Set<String> actionsFired = new HashSet<String>();
        private String name;

        public void resetActionsFired() {
            this.actionsFired.clear();
        }

        public boolean actionFired(String name) {
            return this.actionsFired.contains(name);
        }

        public ActionMock(String name) {
            this.name = name;
        }

        public void execute(ExecutionEnvironment environment) {
            this.actionsFired.add(this.name);
        }

        public void executeSimulation(ExecutionEnvironment environment) {
            throw new UnsupportedOperationException();
        }

        public boolean actionFired() {
            return this.actionFired(this.name);
        }
    }
}

