/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.web;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.web.KSBAction;
import org.kuali.rice.ksb.messaging.web.QuartzQueueForm;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public class QuartzQueueAction
extends KSBAction {
    private static final String RENDER_LIST_OVERRIDE = "_renderlistoverride";

    @Override
    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm form) throws Exception {
        if ("moveToRouteQueue".equals(request.getParameter("methodToCall")) && request.getAttribute(RENDER_LIST_OVERRIDE) == null) {
            return null;
        }
        ArrayList<QuartzQueueForm> jobs = new ArrayList<QuartzQueueForm>();
        String[] jobGroups = KSBServiceLocator.getScheduler().getJobGroupNames();
        for (int i = 0; i < jobGroups.length; ++i) {
            String jobGroup = KSBServiceLocator.getScheduler().getJobGroupNames()[i];
            String[] jobNames = KSBServiceLocator.getScheduler().getJobNames(jobGroup);
            for (int j = 0; j < jobNames.length; ++j) {
                JobDetail job = KSBServiceLocator.getScheduler().getJobDetail(jobNames[j], jobGroup);
                Trigger trigger = KSBServiceLocator.getScheduler().getTriggersOfJob(job.getName(), job.getGroup())[0];
                jobs.add(new QuartzQueueForm(job, trigger));
            }
        }
        request.setAttribute("jobs", jobs);
        return null;
    }

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("joblisting");
    }

    public ActionForward moveToRouteQueue(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuartzQueueForm quartzForm = (QuartzQueueForm)form;
        JobDetail job = KSBServiceLocator.getScheduler().getJobDetail(quartzForm.getJobName(), quartzForm.getJobGroup());
        PersistedMessageBO message = (PersistedMessageBO)job.getJobDataMap().get((Object)"message");
        if (message != null) {
            message.setQueueStatus("E");
            message = KSBServiceLocator.getMessageQueueService().save(message);
            KSBServiceLocator.getScheduler().deleteJob(quartzForm.getJobName(), quartzForm.getJobGroup());
        }
        request.setAttribute(RENDER_LIST_OVERRIDE, new Object());
        this.establishRequiredState(request, form);
        return mapping.findForward("joblisting");
    }
}

