/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.spring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kuali.common.jdbc.project.spring.JdbcPropertyLocationsConfig;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.ProjectResource;
import org.kuali.common.util.properties.PropertiesService;
import org.kuali.common.util.properties.spring.DefaultPropertiesServiceConfig;
import org.kuali.common.util.spring.service.PropertySourceConfig;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.kuali.rice.sql.spring.SourceSqlPropertyLocationsConfig;
import org.kuali.rice.xml.ingest.RiceConfigUtils;
import org.kuali.rice.xml.spring.IngestXmlPropertyLocationsConfig;
import org.kuali.rice.xml.spring.RiceXmlProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
@Import(value={JdbcPropertyLocationsConfig.class, DefaultPropertiesServiceConfig.class, SourceSqlPropertyLocationsConfig.class, IngestXmlPropertyLocationsConfig.class})
public class IngestXmlPSC
implements PropertySourceConfig {
    @Autowired
    JdbcPropertyLocationsConfig jdbcConfig;
    @Autowired
    SourceSqlPropertyLocationsConfig sourceSqlConfig;
    @Autowired
    IngestXmlPropertyLocationsConfig ingestXmlConfig;
    @Autowired
    PropertiesService service;

    @Bean
    public PropertySource<?> propertySource() {
        ArrayList locations = Lists.newArrayList();
        locations.addAll(this.jdbcConfig.jdbcPropertyLocations());
        locations.addAll(this.sourceSqlConfig.riceSourceSqlPropertyLocations());
        locations.addAll(this.ingestXmlConfig.riceIngestXmlPropertyLocations());
        Properties properties = this.service.getProperties((List)locations);
        String location = ProjectUtils.getPath((ProjectResource)RiceXmlProperties.APP.getResource());
        JAXBConfigImpl riceConfig = RiceConfigUtils.parseAndInit(location);
        RiceConfigUtils.putProperties((Config)riceConfig, properties);
        return new PropertiesPropertySource("properties", riceConfig.getProperties());
    }
}

