/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.spring;

import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.event.ApplicationEventListenerConfig;
import org.kuali.common.util.spring.event.ExecutableApplicationEventListener;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.kuali.rice.xml.spring.IngestXmlExecConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

@Configuration
@Import(value={SpringServiceConfig.class})
public class IngestXmlConfig
implements ApplicationEventListenerConfig {
    private static final String ORDER_KEY = "rice.ingest.order";
    @Autowired
    IngestXmlExecConfig config;
    @Autowired
    EnvironmentService env;

    @Bean
    public SmartApplicationListener applicationEventListener() {
        Executable executable = this.config.ingestXmlExecutable();
        Integer order = this.env.getInteger(ORDER_KEY, Integer.valueOf(Integer.MAX_VALUE));
        return ExecutableApplicationEventListener.builder((Executable)executable, ContextRefreshedEvent.class).order(order.intValue()).build();
    }
}

