/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.junit.DefaultTestFinishedEvent;
import org.mockito.internal.junit.UniversalTestListener;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class JUnitRule
implements MockitoRule {
    private final MockitoLogger logger;
    private final UniversalTestListener listener;

    public JUnitRule(MockitoLogger logger, Strictness strictness) {
        this.logger = logger;
        this.listener = new UniversalTestListener(strictness, logger);
    }

    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable testFailure;
                Mockito.framework().addListener(JUnitRule.this.listener);
                try {
                    MockitoAnnotations.initMocks(target);
                    testFailure = this.evaluateSafely(base);
                }
                finally {
                    Mockito.framework().removeListener(JUnitRule.this.listener);
                }
                DefaultTestFinishedEvent event = new DefaultTestFinishedEvent(target, method.getName(), testFailure);
                JUnitRule.this.listener.testFinished(event);
                if (testFailure != null) {
                    throw testFailure;
                }
                Mockito.validateMockitoUsage();
            }

            private Throwable evaluateSafely(Statement base2) {
                try {
                    base2.evaluate();
                    return null;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
        };
    }

    @Override
    public MockitoRule silent() {
        return new JUnitRule(this.logger, Strictness.LENIENT);
    }

    @Override
    public MockitoRule strictness(Strictness strictness) {
        this.listener.setStrictness(strictness);
        return this;
    }
}

