/*
 * Copyright 2008-present MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Evolving;

/**
 * A representation of a {@link CompoundSearchOperator} that allows changing
 * {@link CompoundSearchOperator#should(Iterable) should}-specific options, if any.
 * This interface is a technicality and does not represent a meaningful element of the full-text search query syntax.
 *
 * @see CompoundSearchOperatorBase#should(Iterable)
 * @since 4.7
 */
@Evolving
@Beta(Beta.Reason.CLIENT)
public interface ShouldCompoundSearchOperator extends CompoundSearchOperator {
    @Override
    ShouldCompoundSearchOperator score(SearchScore modifier);
    /**
     * Creates a new {@link ShouldCompoundSearchOperator} that requires at least the requested number of clauses of those specified via
     * {@link CompoundSearchOperatorBase#should(Iterable)} to be satisfied.
     *
     * @param minimumShouldMatch The minimum number of clauses that must be satisfied.
     * @return A new {@link ShouldCompoundSearchOperator}.
     */
    ShouldCompoundSearchOperator minimumShouldMatch(int minimumShouldMatch);
}
