/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.Authorization;
import org.mortbay.jetty.security.SslHttpChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public class HttpConnection
implements Connection {
    HttpDestination _destination;
    EndPoint _endp;
    HttpGenerator _generator;
    HttpParser _parser;
    boolean _http11 = true;
    Buffer _connectionHeader;
    Buffer _requestContentChunk;
    long _last;
    boolean _requestComplete;
    public String _message;
    public Throwable _throwable;
    HttpExchange _exchange;
    HttpExchange _pipeline;
    Timeout.Task _timeout = new Timeout.Task(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            HttpExchange ex = null;
            try {
                HttpConnection httpConnection = HttpConnection.this;
                synchronized (httpConnection) {
                    ex = HttpConnection.this._exchange;
                    HttpConnection.this._exchange = null;
                    if (ex != null) {
                        HttpConnection.this._destination.returnConnection(HttpConnection.this, true);
                    }
                }
            }
            catch (Exception e) {
                Log.debug((Throwable)e);
            }
            finally {
                try {
                    HttpConnection.this._endp.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                if (ex.getStatus() < 7) {
                    ex.setStatus(8);
                }
            }
        }
    };

    public void dump() throws IOException {
        System.err.println("endp=" + this._endp + " " + this._endp.isBufferingInput() + " " + this._endp.isBufferingOutput());
        System.err.println("generator=" + this._generator);
        System.err.println("parser=" + this._parser.getState() + " " + this._parser.isMoreInBuffer());
        System.err.println("exchange=" + this._exchange);
        if (this._endp instanceof SslHttpChannelEndPoint) {
            ((SslHttpChannelEndPoint)this._endp).dump();
        }
    }

    HttpConnection(Buffers buffers, EndPoint endp, int hbs, int cbs) {
        this._endp = endp;
        this._generator = new HttpGenerator(buffers, endp, hbs, cbs);
        this._parser = new HttpParser(buffers, endp, (HttpParser.EventHandler)new Handler(), hbs, cbs);
    }

    public HttpDestination getDestination() {
        return this._destination;
    }

    public void setDestination(HttpDestination destination) {
        this._destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(HttpExchange ex) throws IOException {
        this._throwable = new Throwable();
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._exchange != null) {
                if (this._pipeline != null) {
                    throw new IllegalStateException(this + " PIPELINED!!!  _exchange=" + this._exchange);
                }
                this._pipeline = ex;
                return true;
            }
            if (!this._endp.isOpen()) {
                return false;
            }
            ex.setStatus(2);
            this._exchange = ex;
            if (this._endp.isBlocking()) {
                this.notify();
            } else {
                SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
                scep.scheduleWrite();
            }
            if (!this._endp.isBlocking()) {
                this._destination.getHttpClient().schedule(this._timeout);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle() throws IOException {
        no_progress = 0;
        flushed = 0L;
        failed = false;
        while (true) {
            block87: {
                block88: {
                    block89: {
                        block85: {
                            block86: {
                                if (!this._endp.isBufferingInput() && !this._endp.isOpen()) {
                                    return;
                                }
                                var5_5 = this;
                                synchronized (var5_5) {
                                    while (this._exchange == null) {
                                        if (this._endp.isBlocking()) {
                                            try {
                                                this.wait();
                                                continue;
                                            }
                                            catch (InterruptedException e) {
                                                throw new InterruptedIOException();
                                            }
                                        }
                                        this._parser.fill();
                                        this._parser.skipCRLF();
                                        if (this._parser.isMoreInBuffer()) {
                                            Log.warn((String)"unexpected data");
                                            this._endp.close();
                                        }
                                        return;
                                    }
                                    ** if (this._exchange.getStatus() != 2) goto lbl26
                                }
lbl-1000:
                                // 1 sources

                                {
                                    no_progress = 0;
                                    this.commitRequest();
                                }
lbl26:
                                // 2 sources

                                try {
                                    try {
                                        io = 0L;
                                        this._endp.flush();
                                        if (this._generator.isComplete()) {
                                            if (!this._requestComplete) {
                                                this._requestComplete = true;
                                                this._exchange.getEventListener().onRequestComplete();
                                            }
                                        } else {
                                            var7_7 = this;
                                            synchronized (var7_7) {
                                                if (this._exchange == null) {
                                                    // MONITOREXIT @DISABLED, blocks:[2, 82, 83, 19, 3, 10] lbl41 : MonitorExitStatement: MONITOREXIT : var7_7
                                                    var11_9 = null;
                                                    complete = false;
                                                    close = failed;
                                                    if (failed) break block85;
                                                    break block86;
                                                }
                                                flushed = this._generator.flush();
                                                io += flushed;
                                                ** if (this._generator.isComplete()) goto lbl59
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                in = this._exchange.getRequestContentSource();
                                                if (in != null) {
                                                    if (this._requestContentChunk == null || this._requestContentChunk.length() == 0) {
                                                        this._requestContentChunk = this._exchange.getRequestContentChunk();
                                                        if (this._requestContentChunk != null) {
                                                            this._generator.addContent(this._requestContentChunk, false);
                                                        } else {
                                                            this._generator.complete();
                                                        }
                                                        io += this._generator.flush();
                                                    }
                                                } else {
                                                    this._generator.complete();
                                                }
                                            }
                                        }
lbl59:
                                        // 4 sources

                                        if (!this._parser.isComplete() && this._generator.isCommitted()) {
                                            filled = this._parser.parseAvailable();
                                            io += filled;
                                        }
                                        if (io > 0L) {
                                            no_progress = 0;
                                            break block87;
                                        }
                                        if (no_progress++ < 2 || this._endp.isBlocking()) break block87;
                                        if (!(this._endp instanceof SslHttpChannelEndPoint) || this._generator.isComplete() || this._generator.isEmpty() || this._generator.flush() <= 0L) break block88;
                                        break block89;
                                    }
                                    catch (IOException e) {
                                        var6_15 = this;
                                        synchronized (var6_15) {
                                            if (this._exchange != null) {
                                                this._exchange.getEventListener().onException(e);
                                                this._exchange.setStatus(9);
                                            }
                                        }
                                        failed = true;
                                        throw e;
                                    }
                                }
                                catch (Throwable var10_16) {
                                    var11_9 = null;
                                    complete = false;
                                    close = failed;
                                    if (!failed && this._generator.isComplete()) {
                                        if (!this._requestComplete) {
                                            this._requestComplete = true;
                                            this._exchange.getEventListener().onRequestComplete();
                                        }
                                        if (this._parser.isComplete()) {
                                            this._destination.getHttpClient().cancel(this._timeout);
                                            complete = true;
                                        }
                                    }
                                    if (complete || failed) {
                                        var14_12 = this;
                                        synchronized (var14_12) {
                                            if (!close) {
                                                close = this.shouldClose();
                                            }
                                            this.reset(true);
                                            no_progress = 0;
                                            flushed = -1L;
                                            if (this._exchange != null) {
                                                this._exchange = null;
                                                if (this._pipeline == null) {
                                                    this._destination.returnConnection(this, close);
                                                    if (close) {
                                                        return;
                                                    }
                                                } else {
                                                    if (close) {
                                                        this._destination.returnConnection(this, close);
                                                        this._destination.send(this._pipeline);
                                                        this._pipeline = null;
                                                        return;
                                                    }
                                                    ex = this._pipeline;
                                                    this._pipeline = null;
                                                    this.send(ex);
                                                }
                                            }
                                        }
                                    }
                                    throw var10_16;
                                }
                            }
                            if (this._generator.isComplete()) {
                                if (!this._requestComplete) {
                                    this._requestComplete = true;
                                    this._exchange.getEventListener().onRequestComplete();
                                }
                                if (this._parser.isComplete()) {
                                    this._destination.getHttpClient().cancel(this._timeout);
                                    complete = true;
                                }
                            }
                        }
                        if (!complete && !failed) continue;
                        var14_12 = this;
                        synchronized (var14_12) {
                            if (!close) {
                                close = this.shouldClose();
                            }
                            this.reset(true);
                            no_progress = 0;
                            flushed = -1L;
                            if (this._exchange != null) {
                                this._exchange = null;
                                if (this._pipeline == null) {
                                    this._destination.returnConnection(this, close);
                                    if (close) {
                                        return;
                                    }
                                } else {
                                    if (close) {
                                        this._destination.returnConnection(this, close);
                                        this._destination.send(this._pipeline);
                                        this._pipeline = null;
                                        return;
                                    }
                                    ex = this._pipeline;
                                    this._pipeline = null;
                                    this.send(ex);
                                }
                            }
                            continue;
                        }
                    }
                    var11_9 = null;
                    complete = false;
                    close = failed;
                    if (!failed && this._generator.isComplete()) {
                        if (!this._requestComplete) {
                            this._requestComplete = true;
                            this._exchange.getEventListener().onRequestComplete();
                        }
                        if (this._parser.isComplete()) {
                            this._destination.getHttpClient().cancel(this._timeout);
                            complete = true;
                        }
                    }
                    if (!complete && !failed) continue;
                    var14_12 = this;
                    synchronized (var14_12) {
                        if (!close) {
                            close = this.shouldClose();
                        }
                        this.reset(true);
                        no_progress = 0;
                        flushed = -1L;
                        if (this._exchange != null) {
                            this._exchange = null;
                            if (this._pipeline == null) {
                                this._destination.returnConnection(this, close);
                                if (close) {
                                    return;
                                }
                            } else {
                                if (close) {
                                    this._destination.returnConnection(this, close);
                                    this._destination.send(this._pipeline);
                                    this._pipeline = null;
                                    return;
                                }
                                ex = this._pipeline;
                                this._pipeline = null;
                                this.send(ex);
                            }
                        }
                        continue;
                    }
                }
                var11_9 = null;
                complete = false;
                close = failed;
                if (!failed && this._generator.isComplete()) {
                    if (!this._requestComplete) {
                        this._requestComplete = true;
                        this._exchange.getEventListener().onRequestComplete();
                    }
                    if (this._parser.isComplete()) {
                        this._destination.getHttpClient().cancel(this._timeout);
                        complete = true;
                    }
                }
                if (complete || failed) {
                    var14_12 = this;
                    synchronized (var14_12) {
                        if (!close) {
                            close = this.shouldClose();
                        }
                        this.reset(true);
                        no_progress = 0;
                        flushed = -1L;
                        if (this._exchange != null) {
                            this._exchange = null;
                            if (this._pipeline == null) {
                                this._destination.returnConnection(this, close);
                                if (close) {
                                    return;
                                }
                            } else {
                                if (close) {
                                    this._destination.returnConnection(this, close);
                                    this._destination.send(this._pipeline);
                                    this._pipeline = null;
                                    return;
                                }
                                ex = this._pipeline;
                                this._pipeline = null;
                                this.send(ex);
                            }
                        }
                    }
                }
                return;
            }
            var11_9 = null;
            complete = false;
            close = failed;
            if (!failed && this._generator.isComplete()) {
                if (!this._requestComplete) {
                    this._requestComplete = true;
                    this._exchange.getEventListener().onRequestComplete();
                }
                if (this._parser.isComplete()) {
                    this._destination.getHttpClient().cancel(this._timeout);
                    complete = true;
                }
            }
            if (!complete && !failed) continue;
            var14_12 = this;
            synchronized (var14_12) {
                if (!close) {
                    close = this.shouldClose();
                }
                this.reset(true);
                no_progress = 0;
                flushed = -1L;
                if (this._exchange != null) {
                    this._exchange = null;
                    if (this._pipeline == null) {
                        this._destination.returnConnection(this, close);
                        if (close) {
                            return;
                        }
                    } else {
                        if (close) {
                            this._destination.returnConnection(this, close);
                            this._destination.send(this._pipeline);
                            this._pipeline = null;
                            return;
                        }
                        ex = this._pipeline;
                        this._pipeline = null;
                        this.send(ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            return this._exchange == null;
        }
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRequest() throws IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._exchange.getStatus() != 2) {
                throw new IllegalStateException();
            }
            this._exchange.setStatus(3);
            this._generator.setVersion(this._exchange._version);
            String uri = this._exchange._uri;
            if (this._destination.isProxied() && uri.startsWith("/")) {
                uri = (this._destination.isSecure() ? "https" : "http") + "://" + this._destination.getAddress().getHost() + ":" + this._destination.getAddress().getPort() + uri;
                Authorization auth = this._destination.getProxyAuthentication();
                if (auth != null) {
                    auth.setCredentials(this._exchange);
                }
            }
            this._generator.setRequest(this._exchange._method, uri);
            if (this._exchange._version >= 11 && !this._exchange._requestFields.containsKey(HttpHeaders.HOST_BUFFER)) {
                this._exchange._requestFields.add(HttpHeaders.HOST_BUFFER, this._destination.getHostHeader());
            }
            if (this._exchange._requestContent != null) {
                this._exchange._requestFields.putLongField("Content-Length", (long)this._exchange._requestContent.length());
                this._generator.completeHeader(this._exchange._requestFields, false);
                this._generator.addContent(this._exchange._requestContent, true);
            } else if (this._exchange._requestContentSource != null) {
                this._generator.completeHeader(this._exchange._requestFields, false);
                int available = this._exchange._requestContentSource.available();
                if (available > 0) {
                    byte[] buf = new byte[available];
                    int length = this._exchange._requestContentSource.read(buf);
                    this._generator.addContent((Buffer)new ByteArrayBuffer(buf, 0, length), false);
                }
            } else {
                this._exchange._requestFields.remove("Content-Length");
                this._generator.completeHeader(this._exchange._requestFields, true);
            }
            this._exchange.setStatus(4);
        }
    }

    protected void reset(boolean returnBuffers) throws IOException {
        this._requestComplete = false;
        this._connectionHeader = null;
        this._parser.reset(returnBuffers);
        this._generator.reset(returnBuffers);
        this._http11 = true;
    }

    private boolean shouldClose() {
        if (this._connectionHeader != null) {
            if (HttpHeaderValues.CLOSE_BUFFER.equals(this._connectionHeader)) {
                return true;
            }
            if (HttpHeaderValues.KEEP_ALIVE_BUFFER.equals(this._connectionHeader)) {
                return false;
            }
        }
        return !this._http11;
    }

    public String toString() {
        return "HttpConnection@" + this.hashCode() + "//" + this._destination.getAddress().getHost() + ":" + this._destination.getAddress().getPort();
    }

    public String toDetailString() {
        return this.toString() + " ex=" + this._exchange + " " + this._timeout.getAge();
    }

    public long getLast() {
        return this._last;
    }

    public void setLast(long last) {
        this._last = last;
    }

    public void close() throws IOException {
        this._endp.close();
    }

    private class Handler
    extends HttpParser.EventHandler {
        private Handler() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            HttpConnection.this._http11 = HttpVersions.HTTP_1_1_BUFFER.equals(version);
            HttpConnection.this._exchange.getEventListener().onResponseStatus(version, status, reason);
            HttpConnection.this._exchange.setStatus(5);
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            if (HttpHeaders.CACHE.getOrdinal(name) == 1) {
                HttpConnection.this._connectionHeader = HttpHeaderValues.CACHE.lookup(value);
            }
            HttpConnection.this._exchange.getEventListener().onResponseHeader(name, value);
        }

        public void headerComplete() throws IOException {
            HttpConnection.this._exchange.setStatus(6);
        }

        public void content(Buffer ref) throws IOException {
            HttpConnection.this._exchange.getEventListener().onResponseContent(ref);
        }

        public void messageComplete(long contextLength) throws IOException {
            HttpConnection.this._exchange.setStatus(7);
        }
    }
}

