/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.security;

import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;

public class PassThroughScheme
extends APISecurityScheme {
    public PassThroughScheme(List<Parameter> queryParameters, List<Parameter> headers) {
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.initializeConfigParameters();
    }

    @Override
    public String getSchemeName() {
        return "Pass Through";
    }

    @Override
    protected boolean equalProperties(APISecurityScheme scheme) {
        PassThroughScheme other = (PassThroughScheme)scheme;
        return this.compareParameterList(this.queryParameters, other.queryParameters) && this.compareParameterList(this.headers, other.headers);
    }

    @Override
    public void initializeConfigParameters() {
        this.configParameters = new LinkedList();
        this.configParameters.addAll(this.getQueryParameters());
        this.configParameters.addAll(this.getHeaders());
    }

    private boolean compareParameterList(List<Parameter> thisList, List<Parameter> otherList) {
        if (thisList == null) {
            return otherList == null;
        }
        if (thisList.size() != otherList.size()) {
            return false;
        }
        for (Parameter param : thisList) {
            boolean exists = false;
            for (Parameter otherParam : otherList) {
                if (!param.getExternalName().equals(otherParam.getExternalName())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return false;
        }
        return true;
    }
}

