/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.type;

import java.util.List;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;

public class TypeDefinitionBuilder {
    private TypeDefinition typeDefinition = new TypeDefinition();

    public TypeDefinitionBuilder(MediaType mediaType, TypeSource source, boolean required, boolean arrayType, boolean unionType) {
        this.typeDefinition.setMediaType(mediaType);
        this.typeDefinition.setSource(source);
        this.typeDefinition.setRequired(required);
        this.typeDefinition.setArrayType(arrayType);
        this.typeDefinition.setUnionType(unionType);
    }

    public TypeDefinitionBuilder withDescription(String description) {
        this.typeDefinition.setDescription(description);
        return this;
    }

    public TypeDefinitionBuilder withDefaultValue(String defaultValue) {
        this.typeDefinition.setDefaultValue(defaultValue);
        return this;
    }

    public TypeDefinitionBuilder withExample(String example) {
        this.typeDefinition.setExample(example);
        return this;
    }

    public TypeDefinitionBuilder withAnnotatedDisplayName(String annotatedDisplayName) {
        this.typeDefinition.setAnnotatedDisplayName(annotatedDisplayName);
        return this;
    }

    public TypeDefinitionBuilder withEnumValues(List<String> enumValues) {
        this.typeDefinition.setEnumValues(enumValues);
        return this;
    }

    public static TypeDefinition buildSimpleStringType(boolean required) {
        return new TypeDefinitionBuilder(MediaType.TEXT_PLAIN_TYPE, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), required, false, false).build();
    }

    public static TypeDefinition buildStringTypeWithMediaType(MediaType mediaType, boolean required) {
        return new TypeDefinitionBuilder(mediaType, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), required, false, false).build();
    }

    public static TypeDefinition buildHeaderType() {
        return TypeDefinitionBuilder.buildSimpleStringType(false);
    }

    public static TypeDefinition buildImplicitUriParamType() {
        return new TypeDefinitionBuilder(MediaType.TEXT_PLAIN_TYPE, new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING), true, false, false).build();
    }

    public static TypeDefinition buildSimplePrimitiveType(PrimitiveTypeSource.PrimitiveType primitiveType, boolean required) {
        return new TypeDefinitionBuilder(MediaType.TEXT_PLAIN_TYPE, new PrimitiveTypeSource(primitiveType), required, false, false).build();
    }

    public TypeDefinition build() {
        return this.typeDefinition;
    }
}

