/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration;

import java.util.HashMap;
import java.util.Map;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

public class JsonSchemaPool {
    private Map<String, TypeDefinition> innerPool = new HashMap<String, TypeDefinition>();

    public boolean containsSchema(String schema) {
        return this.innerPool.keySet().stream().anyMatch(x -> x.equals(schema));
    }

    public TypeDefinition getTypeDefinitionForSchema(String schema) throws GenerationException {
        TypeDefinition typeDefinition = this.innerPool.get(schema);
        if (typeDefinition == null) {
            throw new GenerationException("This json schema pool does not contain a type definition for the specified schema");
        }
        return typeDefinition;
    }

    public void putSchemaTypeDefinitionPair(String schema, TypeDefinition typeDefinition) throws GenerationException {
        if (this.containsSchema(schema)) {
            throw new GenerationException("Schema already exists in json schema pool");
        }
        this.innerPool.put(schema, typeDefinition);
    }

    public void reset() {
        this.innerPool = new HashMap<String, TypeDefinition>();
    }
}

