/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration;

import java.io.File;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFModelGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserModelGenerator;

public abstract class ModelGenerator {
    protected final SpecFormat specFormat;
    protected String proxyUri;
    protected String proxyReferer;
    protected boolean safeFileLoader;

    public ModelGenerator(SpecFormat specFormat) {
        this.specFormat = specFormat;
    }

    public abstract RestConnectModelBuilder generateAPIModel(File var1, String var2) throws Exception;

    public RestConnectModelBuilder generateAPIModel(File raml) throws Exception {
        return this.generateAPIModel(raml, raml.getParent());
    }

    public void withSafeProxy(String proxyUri, String proxyReferer) {
        this.proxyUri = proxyUri;
        this.proxyReferer = proxyReferer;
    }

    public void withSafeFileLoader(boolean useSafeFileLoader) {
        this.safeFileLoader = useSafeFileLoader;
    }

    public static ModelGenerator get(SpecFormat format, Parser parser) {
        if (parser.equals((Object)Parser.RAMLParser)) {
            return new RamlParserModelGenerator(format);
        }
        if (parser.equals((Object)Parser.AMF)) {
            return new AMFModelGenerator(format);
        }
        throw new IllegalArgumentException("Parser not supported");
    }
}

