/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.OASConfiguration;
import amf.apicontract.client.platform.RAMLConfiguration;
import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Server;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.FileResourceLoader;
import amf.core.client.platform.resource.HttpResourceLoader;
import amf.core.client.platform.resource.ResourceLoader;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUriBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.ModelGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFOperationGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader.AMFExchangeDependencyResourceLoader;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader.SafeFileResourceLoader;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader.SafeProxyResourceLoader;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.OperationMappingUtils;

public class AMFModelGenerator
extends ModelGenerator {
    private static final Logger logger = LogManager.getLogger(AMFModelGenerator.class);

    public AMFModelGenerator(SpecFormat specFormat) {
        super(specFormat);
    }

    @Override
    public RestConnectModelBuilder generateAPIModel(File raml, String rootDir) throws GenerationException, ExecutionException, InterruptedException {
        AMFConfiguration configuration = AMFModelGenerator.getAMFConfiguration(this.specFormat, rootDir, this.proxyUri, this.proxyReferer, this.safeFileLoader);
        WebApi webApi = this.getWebApi(configuration.baseUnitClient(), raml.toPath());
        Path rootDirPath = new File(rootDir).toPath().toAbsolutePath();
        JsonSchemaPool jsonSchemaPool = new JsonSchemaPool();
        return RestConnectModelBuilder.createModel().withRootDir(rootDirPath).withApiDescription(webApi.description().nonEmpty() ? webApi.description().value() : "").withApiName(webApi.name().value()).withBaseUri(AMFModelGenerator.buildBaseUri(webApi)).withOperations(AMFModelGenerator.buildOperationsModel(webApi, jsonSchemaPool));
    }

    private static List<Operation> buildOperationsModel(WebApi webApi, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (EndPoint endPoint : webApi.endPoints()) {
            for (amf.apicontract.client.platform.model.domain.Operation operation : endPoint.operations()) {
                if (AMFParserUtil.isIgnored(endPoint, operation)) {
                    logger.warn("Resource ignored: {} {}", (Object)operation.method(), (Object)endPoint.path());
                    continue;
                }
                operations.add(AMFOperationGenerator.generateOperation(webApi, endPoint, operation, jsonSchemaPool));
            }
        }
        OperationMappingUtils.disambiguateRepeatedOperations(operations);
        return operations;
    }

    private static BaseUri buildBaseUri(WebApi api) {
        String url = "";
        for (Server server : api.servers()) {
            if (!server.url().nonEmpty()) continue;
            url = server.url().value();
            break;
        }
        return BaseUriBuilder.buildBaseUri(url, api.version().value());
    }

    private static AMFConfiguration getAMFConfiguration(SpecFormat format, String rootDir, String proxyBaseUri, String proxyReferer, boolean safeFileLoader) {
        AMFConfiguration amfConfiguration;
        if (format.equals((Object)SpecFormat.RAML)) {
            amfConfiguration = RAMLConfiguration.RAML10();
        } else if (format.equals((Object)SpecFormat.JSON_OAS) || format.equals((Object)SpecFormat.YAML_OAS)) {
            amfConfiguration = OASConfiguration.OAS20();
        } else if (format.equals((Object)SpecFormat.YAML_OAS3) || format.equals((Object)SpecFormat.JSON_OAS3)) {
            amfConfiguration = OASConfiguration.OAS30();
        } else {
            throw new IllegalArgumentException("Spec format " + format.getName() + "not supported");
        }
        return amfConfiguration.withResourceLoaders(AMFModelGenerator.getResourceLoaders(rootDir, proxyBaseUri, proxyReferer, safeFileLoader));
    }

    private static List<ResourceLoader> getResourceLoaders(String rootDir, String proxyBaseUri, String proxyReferer, boolean safeFileLoader) {
        LinkedList<ResourceLoader> resourceLoaders = new LinkedList<ResourceLoader>();
        if (StringUtils.isNotBlank((CharSequence)proxyBaseUri)) {
            resourceLoaders.add((ResourceLoader)new SafeProxyResourceLoader(proxyBaseUri, proxyReferer));
        } else {
            resourceLoaders.add((ResourceLoader)new HttpResourceLoader());
        }
        if (safeFileLoader) {
            resourceLoaders.add((ResourceLoader)new SafeFileResourceLoader(rootDir));
        } else {
            resourceLoaders.add((ResourceLoader)new FileResourceLoader());
        }
        resourceLoaders.add(new AMFExchangeDependencyResourceLoader(rootDir));
        return resourceLoaders;
    }

    public WebApi getWebApi(AMFBaseUnitClient client, Path path) {
        if (this.isRaml08(path.toAbsolutePath())) {
            throw new InvalidSourceException("RAML 0.8 is not supported.");
        }
        return this.parseWebApi(client, path);
    }

    private void validateDocument(AMFBaseUnitClient client, Document document) {
        AMFValidationReport report;
        try {
            report = (AMFValidationReport)client.validate((BaseUnit)document).get();
        }
        catch (Exception e) {
            throw new InvalidSourceException("Could not validate API.");
        }
        if (!report.conforms()) {
            throw new InvalidSourceException("The provided API specification has errors.\n" + report);
        }
    }

    private WebApi parseWebApi(AMFBaseUnitClient client, Path path) {
        AMFParseResult amfParseResult;
        try {
            amfParseResult = (AMFParseResult)client.parse("file://" + path.toAbsolutePath()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("An error happened while parsing the API specification", e);
        }
        if (!amfParseResult.conforms()) {
            throw new InvalidSourceException("The provided API specification has errors.\n" + amfParseResult.results().stream().map(AMFValidationResult::message).collect(Collectors.joining(System.lineSeparator())));
        }
        BaseUnit baseUnit = client.transform(amfParseResult.baseUnit()).baseUnit();
        if (!(baseUnit instanceof Document)) {
            throw new InvalidSourceException("Document type not supported: " + baseUnit.getClass());
        }
        Document document = (Document)baseUnit;
        this.validateDocument(client, document);
        return (WebApi)document.encodes();
    }

    private boolean isRaml08(Path specPath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(specPath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.startsWith("#%RAML 0.8");
    }
}

