/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.AMFSecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;

public class AMFOperationGenerator {
    public static Operation generateOperation(WebApi api, EndPoint endPoint, amf.apicontract.client.platform.model.domain.Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        String friendlyName = AMFParserUtil.getMethodDisplayName(operation);
        String annotatedName = AMFParserUtil.getAnnotatedOperationName(operation);
        return new OperationBuilder().withFriendlyName(friendlyName).withAnnotatedDisplayName(StringUtils.isNotBlank((CharSequence)annotatedName) ? annotatedName : friendlyName).withCanonicalName(AMFParserUtil.getCanonicalOperationName(endPoint, operation, friendlyName)).withDescription(AMFOperationGenerator.buildOperationDescription(endPoint, operation)).withHttpMethod(HTTPMethod.fromString(operation.method().value())).withUri(endPoint.path().value()).withUriParams(AMFOperationGenerator.buildUriParams(endPoint, operation, jsonSchemaPool)).withQueryParams(AMFOperationGenerator.buildQueryParams(operation, jsonSchemaPool)).withHeaders(AMFOperationGenerator.buildHeaders(operation, jsonSchemaPool)).withInputMetadata(AMFTypeDefinitionFactory.buildInputMetadata(operation, jsonSchemaPool)).withOutputMetadata(AMFTypeDefinitionFactory.buildOutputMetadata(operation, jsonSchemaPool)).withSecuritySchemes(AMFSecuritySchemeFactory.getSchemesForOperation(api, endPoint, operation, jsonSchemaPool)).withUserSelectedSecuritySchemes(AMFParserUtil.isUserSelectedSecuritySchemes(endPoint, operation, api)).build();
    }

    private static String buildOperationDescription(EndPoint endPoint, amf.apicontract.client.platform.model.domain.Operation operation) {
        return operation.description().nonEmpty() ? operation.description().value() : endPoint.description().value();
    }

    private static List<Parameter> buildUriParams(EndPoint endPoint, amf.apicontract.client.platform.model.domain.Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        LinkedList<amf.apicontract.client.platform.model.domain.Parameter> uriParameters = new LinkedList<amf.apicontract.client.platform.model.domain.Parameter>(endPoint.parameters());
        if (operation.request() != null) {
            uriParameters.addAll(operation.request().uriParameters());
        }
        return AMFParserUtil.getParameterList(uriParameters, ParameterType.URI, jsonSchemaPool);
    }

    private static List<Parameter> buildQueryParams(amf.apicontract.client.platform.model.domain.Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if (operation.request() != null) {
            if (operation.request().queryString() != null) {
                return AMFOperationGenerator.buildQueryParametersFromQueryString(operation);
            }
            return AMFParserUtil.getParameterList(operation.request().queryParameters(), ParameterType.QUERY, jsonSchemaPool);
        }
        return new ArrayList<Parameter>();
    }

    private static List<Parameter> buildQueryParametersFromQueryString(amf.apicontract.client.platform.model.domain.Operation operation) {
        HashSet parameters = new HashSet();
        if (operation.request().queryString() instanceof UnionShape) {
            ((UnionShape)operation.request().queryString()).anyOf().stream().forEach(shape -> ((NodeShape)shape).properties().stream().forEach(p -> parameters.add(p.name().value())));
        } else if (operation.request().queryString() instanceof NodeShape) {
            ((NodeShape)operation.request().queryString()).properties().stream().forEach(p -> parameters.add(p.name().value()));
        }
        return new ArrayList(parameters).stream().map(p -> new Parameter((String)p, ParameterType.QUERY, TypeDefinitionBuilder.buildSimpleStringType(false))).collect(Collectors.toList());
    }

    private static List<Parameter> buildHeaders(amf.apicontract.client.platform.model.domain.Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if (operation.request() != null) {
            return AMFParserUtil.getParameterList(operation.request().headers(), ParameterType.HEADER, jsonSchemaPool);
        }
        return new ArrayList<Parameter>();
    }
}

