/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.JwtAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.common.security.SecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.RamlParserOauth2FlowsNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.RamlParserSecuritySchemesNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.api.model.v10.security.SecuritySchemePart;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.api.model.v10.system.types.Reference;

public class RamlParserSecuritySchemeFactory {
    public static List<APISecurityScheme> getOperationSecuritySchemes(Api api, Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        List<SecurityScheme> globalSchemes = api.securedBy().stream().map(x -> x != null ? x.securityScheme() : null).collect(Collectors.toList());
        Resource endPoint = method.resource();
        List<SecurityScheme> endPointSchemes = endPoint.securedBy().stream().map(x -> x != null ? x.securityScheme() : null).collect(Collectors.toList());
        return RamlParserSecuritySchemeFactory.getMethodSecuritySchemes(method, endPointSchemes, globalSchemes, jsonSchemaPool);
    }

    private static List<APISecurityScheme> getAPISecuritySchemes(List<SecurityScheme> sourceSchemes, JsonSchemaPool jsonSchemaPool) throws Exception {
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        for (SecurityScheme scheme : sourceSchemes) {
            List<APISecurityScheme> generatedSchemes = RamlParserSecuritySchemeFactory.createSecuritySchemes(scheme, jsonSchemaPool);
            for (APISecurityScheme generatedScheme : generatedSchemes) {
                if (!returnSchemes.stream().noneMatch(x -> x.equals(generatedScheme))) continue;
                returnSchemes.add(generatedScheme);
            }
        }
        if (!sourceSchemes.isEmpty() && returnSchemes.isEmpty()) {
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes ( " + RamlParserSecuritySchemeFactory.listSchemes(sourceSchemes) + ") are supported.");
        }
        return returnSchemes;
    }

    private static List<APISecurityScheme> getMethodSecuritySchemes(Method method, List<SecurityScheme> endPointSchemes, List<SecurityScheme> globalSchemes, JsonSchemaPool jsonSchemaPool) throws Exception {
        List methodSchemes = method.securedBy().stream().map(x -> x != null ? x.securityScheme() : null).collect(Collectors.toList());
        List<SecurityScheme> securitySchemesForOperation = SecuritySchemeFactory.getSecuritySchemesForOperation(methodSchemes, endPointSchemes, globalSchemes);
        if (!securitySchemesForOperation.isEmpty()) {
            return RamlParserSecuritySchemeFactory.getAPISecuritySchemes(securitySchemesForOperation, jsonSchemaPool);
        }
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        returnSchemes.add(new UnsecuredScheme());
        return returnSchemes;
    }

    private static List<APISecurityScheme> createSecuritySchemes(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws Exception {
        LinkedList<APISecurityScheme> apiSecuritySchemes = new LinkedList<APISecurityScheme>();
        if (securityScheme == null) {
            apiSecuritySchemes.add(new UnsecuredScheme());
            return apiSecuritySchemes;
        }
        String schemeType = securityScheme.type();
        if (RamlParserSecuritySchemesNaming.isBasicAuth(schemeType)) {
            apiSecuritySchemes.add(new BasicAuthScheme());
        } else if (RamlParserSecuritySchemesNaming.isPassThrough(schemeType)) {
            apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildPassThroughSecurityScheme(securityScheme, jsonSchemaPool));
        } else if (RamlParserSecuritySchemesNaming.isOauth2(schemeType)) {
            for (String grant : securityScheme.settings().authorizationGrants()) {
                if (RamlParserOauth2FlowsNaming.isAuthorizationCode(grant)) {
                    apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildOAuth2AuthorizationCodeSecurityScheme(securityScheme));
                    continue;
                }
                if (!RamlParserOauth2FlowsNaming.isClientCredentials(grant)) continue;
                apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildOAuth2ClientCredentialsSecurityScheme(securityScheme));
            }
        } else if (RamlParserSecuritySchemesNaming.isDigestAuth(schemeType)) {
            apiSecuritySchemes.add(new DigestAuthenticationScheme());
        } else if (RamlParserSecuritySchemesNaming.isJwtAuth(schemeType)) {
            apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildJwtAuthenticationScheme(securityScheme, jsonSchemaPool));
        } else if (RamlParserSecuritySchemesNaming.isCustom(schemeType)) {
            apiSecuritySchemes.add(RamlParserSecuritySchemeFactory.buildCustomAuthenticationSecurityScheme(securityScheme, jsonSchemaPool));
        }
        return apiSecuritySchemes;
    }

    private static PassThroughScheme buildPassThroughSecurityScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws Exception {
        SecuritySchemePart describedBy = securityScheme.describedBy();
        List<Parameter> queryParameters = RamlParserUtils.getParameterList(describedBy.queryParameters(), ParameterType.QUERY, jsonSchemaPool);
        List<Parameter> headers = RamlParserUtils.getParameterList(describedBy.headers(), ParameterType.HEADER, jsonSchemaPool);
        return new PassThroughScheme(queryParameters, headers);
    }

    private static JwtAuthenticationScheme buildJwtAuthenticationScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws Exception {
        TypeInstance root = securityScheme.describedBy().annotations().stream().map(Reference::structuredValue).findFirst().get();
        ArrayList<Parameter> headers = new ArrayList<Parameter>();
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.headers.alg")).map(alg -> RamlParserSecuritySchemeFactory.parse(alg, "alg", "Encryption Algorithm", "Algorithm used to sign and encrypt the JWT tokens.")).ifPresent(headers::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.headers.typ")).map(typ -> RamlParserSecuritySchemeFactory.parse(typ, "typ", "Token Media Type", "Header Parameter defined by JWT applications to declare the media type of this complete JWT.")).ifPresent(headers::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.headers.cty")).map(cty -> RamlParserSecuritySchemeFactory.parse(cty, "cty", "Token Content Type", "Header Parameter defined by JWT applications to convey structural information about the token.")).ifPresent(headers::add);
        RamlParserSecuritySchemeFactory.getProperty(RamlParserSecuritySchemeFactory.get(root, "body.jwt.headers"), "custom").map(TypeInstanceProperty::values).ifPresent(customHeaders -> customHeaders.stream().map(RamlParserSecuritySchemeFactory::getCustomParameter).forEach(headers::add));
        ArrayList<Parameter> claims = new ArrayList<Parameter>();
        ArrayList<Parameter> accessTokenRequestParameters = new ArrayList<Parameter>();
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims.iss")).map(iss -> RamlParserSecuritySchemeFactory.parse(iss, "iss", "Issuer", "The \"iss\" (issuer) claim identifies the principal that issued the JWT.  The processing of this claim is generally application specific. The \"iss\" value is a case-sensitive string containing a StringOrURI value.")).ifPresent(claims::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims.sub")).map(aud -> RamlParserSecuritySchemeFactory.parse(aud, "sub", "Subject", "The \"sub\" (subject) claim identifies the principal that is the subject of the JWT.")).ifPresent(claims::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims.aud")).map(aud -> RamlParserSecuritySchemeFactory.parse(aud, "aud", "Audience", "The \"aud\" (audience) claim identifies the recipients that the JWT is intended for.  Each principal intended to process the JWT MUST identify itself with a value in the audience claim.  If the principal processing the claim does not identify itself with a value in the \"aud\" claim when this claim is present, then the JWT MUST be rejected.")).ifPresent(claims::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims.jti")).map(jti -> RamlParserSecuritySchemeFactory.parse(jti, "jti", "JWT ID", "The \"jti\" (JWT ID) claim provides a unique identifier for the JWT. The identifier value MUST be assigned in a manner that ensures that there is a negligible probability that the same value will be accidentally assigned to a different data object.")).ifPresent(claims::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims.exp")).map(exp -> RamlParserSecuritySchemeFactory.parse(exp, "exp", "Expiration Time", "The \"exp\" (expiration time) claim identifies the expiration time on or after which the JWT MUST NOT be accepted for processing.")).ifPresent(claims::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims.iat")).map(iat -> RamlParserSecuritySchemeFactory.parse(iat, "iat", "Issued At", "The \"iat\" (issued at) claim identifies the time at which the JWT was issued.  This claim can be used to determine the age of the JWT.  Its value MUST be a number containing a NumericDate value.")).ifPresent(claims::add);
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims.nbf")).map(nbf -> RamlParserSecuritySchemeFactory.parse(nbf, "nbf", "Not Before", "The \"nbf\" (not before) claim identifies the time before which the JWT MUST NOT be accepted for processing.  The processing of the \"nbf\" claim requires that the current date/time MUST be after or equal to the not-before date/time listed in the \"nbf\" claim.")).ifPresent(claims::add);
        RamlParserSecuritySchemeFactory.getProperty(RamlParserSecuritySchemeFactory.get(root, "body.jwt.claims"), "custom").map(TypeInstanceProperty::values).ifPresent(customClaims -> customClaims.stream().map(RamlParserSecuritySchemeFactory::getCustomParameter).forEach(claims::add));
        RamlParserSecuritySchemeFactory.getProperty(RamlParserSecuritySchemeFactory.get(root, "body"), "parameters").map(TypeInstanceProperty::values).ifPresent(customClaims -> customClaims.stream().map(RamlParserSecuritySchemeFactory::getCustomParameter).forEach(accessTokenRequestParameters::add));
        Optional.ofNullable(RamlParserSecuritySchemeFactory.get(root, "url")).map(url -> APISecurityScheme.getSecuritySchemeParameter("url", "URL", PrimitiveTypeSource.PrimitiveType.STRING, "Access Token retrieval URL.", null, null, false, false, false, url.value().toString())).ifPresent(accessTokenRequestParameters::add);
        return new JwtAuthenticationScheme(headers, claims, accessTokenRequestParameters);
    }

    private static Parameter parse(TypeInstance instance, String name, String displayName, String description) {
        return APISecurityScheme.getSecuritySchemeParameter(name, displayName, PrimitiveTypeSource.PrimitiveType.STRING, description, RamlParserSecuritySchemeFactory.getStringValue(instance, "defaultValue", null), null, (boolean)RamlParserSecuritySchemeFactory.getBooleanValue(instance, "required", Boolean.FALSE), false, RamlParserSecuritySchemeFactory.getBooleanValue(instance, "generated", Boolean.FALSE), RamlParserSecuritySchemeFactory.getProperty(instance, "restrictedValues").map(TypeInstanceProperty::values).map(restrictedValueInstances -> restrictedValueInstances.stream().map(TypeInstance::value).map(String.class::cast).collect(Collectors.toList()).toArray(new String[0])).orElse(new String[0]));
    }

    private static Parameter getCustomParameter(TypeInstance instance) {
        String name = RamlParserSecuritySchemeFactory.getStringValue(instance, "name", null);
        return APISecurityScheme.getSecuritySchemeParameter(name, RamlParserSecuritySchemeFactory.getStringValue(instance, "displayName", name), PrimitiveTypeSource.PrimitiveType.STRING, RamlParserSecuritySchemeFactory.getStringValue(instance, "description", null), RamlParserSecuritySchemeFactory.getStringValue(instance, "defaultValue", null), null, (boolean)RamlParserSecuritySchemeFactory.getBooleanValue(instance, "required", Boolean.FALSE), false, RamlParserSecuritySchemeFactory.getProperty(instance, "restrictedValues").map(TypeInstanceProperty::values).map(restrictedValueInstances -> restrictedValueInstances.stream().map(TypeInstance::value).map(String.class::cast).collect(Collectors.toList()).toArray(new String[0])).orElse(new String[0]));
    }

    private static String getStringValue(TypeInstance instance, String key, String option) {
        return RamlParserSecuritySchemeFactory.getValue(instance, String.class, key, option);
    }

    private static Boolean getBooleanValue(TypeInstance instance, String key, Boolean option) {
        return RamlParserSecuritySchemeFactory.getValue(instance, Boolean.class, key, option);
    }

    private static <T> T getValue(TypeInstance instance, Class<T> type, String key, T option) {
        return (T)RamlParserSecuritySchemeFactory.getProperty(instance, key).map(TypeInstanceProperty::value).map(TypeInstance::value).map(type::cast).orElse(option);
    }

    private static TypeInstance get(TypeInstance instance, String key) {
        return RamlParserSecuritySchemeFactory.get(instance, Stream.of(key.split("\\.")).collect(Collectors.toList()));
    }

    private static TypeInstance get(TypeInstance instance, List<String> path) {
        if (path.isEmpty()) {
            return instance;
        }
        return RamlParserSecuritySchemeFactory.getProperty(instance, path.remove(0)).map(TypeInstanceProperty::value).map(property -> RamlParserSecuritySchemeFactory.get(property, path)).orElse(null);
    }

    private static Optional<TypeInstanceProperty> getProperty(TypeInstance instance, String propertyName) {
        return instance.properties().stream().filter(property -> property.name().equals(propertyName)).findFirst();
    }

    private static APISecurityScheme buildCustomAuthenticationSecurityScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws Exception {
        SecuritySchemePart describedBy = securityScheme.describedBy();
        List<Parameter> queryParameters = RamlParserUtils.getParameterList(describedBy.queryParameters(), ParameterType.QUERY, jsonSchemaPool);
        List<Parameter> headers = RamlParserUtils.getParameterList(describedBy.headers(), ParameterType.HEADER, jsonSchemaPool);
        return new CustomAuthenticationScheme(queryParameters, headers);
    }

    private static OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeSecurityScheme(SecurityScheme securityScheme) {
        String authorizationUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().authorizationUri());
        String accessTokenUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().accessTokenUri());
        List authorizationGrants = Arrays.asList((Object[])new String[]{"authorization_code"});
        List scopes = securityScheme.settings().scopes();
        String renewTokenExpression = RamlParserUtils.getAnnotatedRenewTokenExpression(securityScheme);
        return new OAuth2AuthorizationCodeScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes, renewTokenExpression);
    }

    private static OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsSecurityScheme(SecurityScheme securityScheme) {
        String authorizationUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().authorizationUri());
        String accessTokenUri = RamlParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().accessTokenUri());
        List authorizationGrants = Arrays.asList((Object[])new String[]{"client_credentials"});
        List scopes = securityScheme.settings().scopes();
        String renewTokenExpression = RamlParserUtils.getAnnotatedRenewTokenExpression(securityScheme);
        return new OAuth2ClientCredentialsScheme(authorizationUri, accessTokenUri, authorizationGrants, scopes, renewTokenExpression);
    }

    private static String listSchemes(List<SecurityScheme> securitySchemes) {
        StringBuilder builder = new StringBuilder();
        for (SecurityScheme securityScheme : securitySchemes) {
            builder.append(securityScheme.type());
            builder.append("<");
            builder.append(securityScheme.name());
            builder.append(">");
            if (securityScheme.type().equals("OAuth 2.0")) {
                builder.append(" :");
                for (String grant : securityScheme.settings().authorizationGrants()) {
                    builder.append(" ");
                    builder.append(grant);
                }
            }
            builder.append(". ");
        }
        return builder.toString();
    }
}

