/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.templateEngine.SmartConnectorGeneratedSources;
import org.mule.connectivity.restconnect.internal.templateEngine.TemplateEngine;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.SmartConnectorTemplateEngineBuilder;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.SmartConnectorModelDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.SmartConnectorOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class SmartConnectorTemplateEngine
extends TemplateEngine {
    private static final String EXTENSION = "extension";
    private static final String OPERATION = "operation";
    private static final String CATALOG_VM = "templates/smartConnector/catalog.vm";
    private static final String MODULE_VM = "templates/smartConnector/module.vm";
    private static final String MULE_ARTIFACT_VM = "templates/smartConnector/mule-artifact.vm";
    private static final String SECURITY_SCHEME_ENUM_VM = "templates/smartConnector/possible-security-scheme-enum.vm";
    private static final String REQ_STREAMING_MODE_ENUM_VM = "templates/smartConnector/request-streaming-mode-enum.vm";
    private static final String POM_VM = "templates/smartConnector/pom.vm";
    private static final String ICON_PATH = "jarResources/images/icon.svg";
    private static final Path RESOURCES_DIR = Paths.get("src/main/resources", new String[0]);
    private static final String PROPERTIES_RESOURCE = "/project.properties";
    private static final String APPLICATION_PROPERTIES = "properties";
    private final SmartConnectorModelDecorator model;
    private final Path outputDir;
    private SmartConnectorGeneratedSources generatedSources;

    public SmartConnectorTemplateEngine(SmartConnectorTemplateEngineBuilder builder) {
        this.model = new SmartConnectorModelDecorator(builder.getModel());
        this.outputDir = builder.getOutputDir();
        this.generatedSources = new SmartConnectorGeneratedSources(this.outputDir);
    }

    @Override
    public void applyTemplates() throws Exception {
        this.generateCatalog();
        this.generateVMTemplates();
        this.generateAssetFiles();
    }

    private void generateAssetFiles() throws IOException {
        this.generateIconFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateIconFile() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream stream = null;
        OutputStream outStream = null;
        try {
            Path output = this.outputDir.resolve("icon.svg");
            stream = classLoader.getResourceAsStream(ICON_PATH);
            byte[] buffer = new byte[stream.available()];
            stream.read(buffer);
            File targetFile = output.toFile();
            outStream = new FileOutputStream(targetFile);
            outStream.write(buffer);
            this.generatedSources.setIcon(output);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    private void generateCatalog() throws Exception {
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        this.generatedSources.addCatalogSchema(this.applyTemplate(REQ_STREAMING_MODE_ENUM_VM, outputResourcesDir.resolve("request-streaming-mode-enum.json"), new VelocityContext()));
        for (SmartConnectorOperationDecorator operation : this.model.getDecoratedOperations()) {
            if (operation.getDecoratedInputMetadata() != null && operation.getDecoratedInputMetadata().requiresCatalog()) {
                this.generatedSources.addCatalogSchema(operation.getDecoratedInputMetadata().writeSchema(outputResourcesDir));
            }
            if (operation.getDecoratedOutputMetadata() != null && operation.getDecoratedOutputMetadata().requiresCatalog()) {
                this.generatedSources.addCatalogSchema(operation.getDecoratedOutputMetadata().writeSchema(outputResourcesDir));
            }
            for (SmartConnectorTypeDefinitionDecorator parameter : operation.getDecoratedParameters()) {
                if (!parameter.requiresCatalog()) continue;
                this.generatedSources.addCatalogSchema(parameter.writeSchema(outputResourcesDir));
            }
            if (!operation.isUserSelectedSecuritySchemes()) continue;
            VelocityContext context = new VelocityContext((Context)velocityToolManager.createContext());
            context.internalPut(OPERATION, (Object)operation);
            String fileName = String.format("%s-security-scheme-enum.json", operation.getName());
            operation.setAllSecuritySchemesFilename(fileName);
            this.generatedSources.addCatalogSchema(this.applyTemplate(SECURITY_SCHEME_ENUM_VM, outputResourcesDir.resolve(fileName), context));
        }
        this.addXmlSchemasRecursivelyToOutput(this.model.getRootDir().toFile(), outputResourcesDir);
    }

    public void addXmlSchemasRecursivelyToOutput(File file, Path outputDirectory) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && !file.getName().equalsIgnoreCase("target")) {
            for (File subFile : Objects.requireNonNull(file.listFiles())) {
                this.addXmlSchemasRecursivelyToOutput(subFile, outputDirectory);
            }
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                }

                @Override
                public void error(SAXParseException exception) {
                }

                @Override
                public void fatalError(SAXParseException exception) {
                }
            });
            Document doc = dBuilder.parse(file);
            this.copyRelativizedFile(outputDirectory, file.toPath());
            this.generatedSources.addComplementaryXmlSchema(file.toPath());
        }
        catch (Exception e) {
            return;
        }
    }

    private void generateVMTemplates() throws Exception {
        VelocityContext context = new VelocityContext((Context)velocityToolManager.createContext());
        context.internalPut(EXTENSION, (Object)this.model);
        context.internalPut(APPLICATION_PROPERTIES, (Object)this.getApplicationProperties());
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        this.generatedSources.setPom(this.applyTemplate(POM_VM, this.outputDir.resolve("pom.xml"), context));
        this.checkPomIsConsistent(this.generatedSources.getPom());
        this.generatedSources.setModule(this.applyTemplate(MODULE_VM, outputResourcesDir.resolve(String.format("module-%s.xml", this.model.getModulePrefix())), context));
        this.generatedSources.setCatalog(this.applyTemplate(CATALOG_VM, outputResourcesDir.resolve(String.format("module-%s-catalog.xml", this.model.getModulePrefix())), context));
        this.generatedSources.setArtifact(this.applyTemplate(MULE_ARTIFACT_VM, this.outputDir.resolve("mule-artifact.json"), context));
    }

    public void packageProject() throws Exception {
        Path packageFolder = this.outputDir.resolve("package");
        Files.createDirectories(packageFolder, new FileAttribute[0]);
        this.createJarFile(packageFolder);
    }

    private void createJarFile(Path packageFolder) throws Exception {
        Path jarDir = Files.createTempDirectory("jar-temp", new FileAttribute[0]);
        Path metaInfDir = jarDir.resolve(Paths.get("META-INF", new String[0]));
        metaInfDir.toFile().mkdirs();
        Path muleArtifactDir = metaInfDir.resolve(Paths.get("mule-artifact", new String[0]));
        muleArtifactDir.toFile().mkdirs();
        Path mavenDir = metaInfDir.resolve(Paths.get("maven/" + this.model.getGroupId() + "/" + this.model.getArtifactId(), new String[0]));
        mavenDir.toFile().mkdirs();
        Files.copy(this.generatedSources.getCatalog(), jarDir.resolve(this.generatedSources.getCatalog().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getModule(), jarDir.resolve(this.generatedSources.getModule().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getArtifact(), muleArtifactDir.resolve(this.generatedSources.getArtifact().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getIcon(), muleArtifactDir.resolve(this.generatedSources.getIcon().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getPom(), mavenDir.resolve(this.generatedSources.getPom().getFileName()), new CopyOption[0]);
        for (Path path : this.generatedSources.getDistinctCatalogSchemas()) {
            Files.copy(path, jarDir.resolve(path.getFileName()), new CopyOption[0]);
        }
        for (Path path : this.generatedSources.getDistinctComplementaryXmlSchemas()) {
            this.copyRelativizedFile(jarDir, path);
        }
        String jarName = String.format("%s-%s-mule-plugin.jar", this.model.getArtifactId(), this.model.getVersion());
        Path outputJarFile = packageFolder.resolve(jarName);
        FileGenerationUtils.generateJarFileFromDirectory(jarDir, outputJarFile);
    }

    private void copyRelativizedFile(Path destinationDir, Path fileToCopy) throws IOException {
        String stringPathInJar = fileToCopy.toString().replace(this.model.getRootDir().toString() + "/", "");
        stringPathInJar = stringPathInJar.replace(this.model.getRootDir().toString() + "\\", "");
        Path jarPath = destinationDir.resolve(stringPathInJar = stringPathInJar.replace(this.model.getRootDir().toString(), ""));
        if (!jarPath.getParent().toFile().exists()) {
            jarPath.getParent().toFile().mkdirs();
        }
        Files.copy(fileToCopy, jarPath, new CopyOption[0]);
    }

    private Properties getApplicationProperties() throws IOException {
        try (InputStream input = this.getClass().getResourceAsStream(PROPERTIES_RESOURCE);){
            Properties prop = new Properties();
            prop.load(input);
            Properties properties = prop;
            return properties;
        }
    }

    private String getGrants(List<APISecurityScheme> schemas) {
        ArrayList<String> grants = new ArrayList<String>();
        for (APISecurityScheme schema : schemas) {
            if (!(schema instanceof OAuth2Scheme)) continue;
            grants.addAll(((OAuth2Scheme)schema).getAuthorizationGrants());
        }
        return StringUtils.join(grants, (String)", ");
    }
}

