/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model;

import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.model.MavenDependency;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;

public abstract class ModelDecorator {
    protected final RestConnectAPIModel model;

    protected ModelDecorator(RestConnectAPIModel model) {
        this.model = model;
    }

    public String getGroupId() {
        return this.model.getGroupId();
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    public String getVersion() {
        return this.model.getVersion();
    }

    public String getCustomPackage() {
        return this.model.getCustomPackage();
    }

    public String getApiName() {
        return StringUtils.isNotEmpty((CharSequence)this.model.getApiName()) ? this.model.getApiName() : "empty";
    }

    public String getApiDescription() {
        return this.model.getApiDescription();
    }

    public ConnectorCategory getCategory() {
        return this.model.getCategory();
    }

    public List<Operation> getOperations() {
        return this.model.getOperations();
    }

    public BaseUri getBaseUri() {
        return this.model.getBaseUri();
    }

    public List<MavenDependency> getDependencies() {
        return this.model.getDependencies();
    }

    public Path getRootDir() {
        return this.model.getRootDir();
    }

    public String getGAV() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }
}

