/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model;

import java.util.List;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;

public class SmartConnectorSecuritySchemeHelper {
    public static APISecurityScheme getPrioritarySecurityScheme(List<APISecurityScheme> schemes) {
        if (schemes == null || schemes.size() == 0) {
            return new UnsecuredScheme();
        }
        for (APISecurityScheme scheme : schemes) {
            if (!scheme.getSchemeName().equals("Basic Authentication")) continue;
            return scheme;
        }
        for (APISecurityScheme scheme : schemes) {
            if (!scheme.getSchemeName().equals("OAuth 2.0")) continue;
            for (String grant : ((OAuth2Scheme)scheme).getAuthorizationGrants()) {
                if (!grant.equals("client_credentials")) continue;
                return scheme;
            }
        }
        for (APISecurityScheme scheme : schemes) {
            if (!scheme.getSchemeName().equals("OAuth 2.0")) continue;
            for (String grant : ((OAuth2Scheme)scheme).getAuthorizationGrants()) {
                if (!grant.equals("authorization_code")) continue;
                return scheme;
            }
        }
        for (APISecurityScheme scheme : schemes) {
            if (!scheme.getSchemeName().equals("Pass Through")) continue;
            return scheme;
        }
        for (APISecurityScheme scheme : schemes) {
            if (!scheme.getSchemeName().equals("Digest Authentication")) continue;
            return scheme;
        }
        for (APISecurityScheme scheme : schemes) {
            if (!scheme.getSchemeName().equals("Custom Authentication")) continue;
            return scheme;
        }
        for (APISecurityScheme scheme : schemes) {
            if (!scheme.getSchemeName().equals("")) continue;
            return scheme;
        }
        return schemes.get(0);
    }
}

