/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.SocketAttributes;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.client.SocketClient;
import org.mule.extension.socket.api.exceptions.ReadingTimeoutException;
import org.mule.extension.socket.api.socket.udp.UdpSocketProperties;
import org.mule.extension.socket.internal.SocketUtils;

public final class UdpClient
implements SocketClient {
    private final UdpSocketProperties socketProperties;
    private final DatagramSocket socket;
    private final SocketAddress socketAddress;

    public UdpClient(DatagramSocket socket, SocketConnectionSettings connectionSettings, UdpSocketProperties socketProperties) {
        this.socketProperties = socketProperties;
        this.socket = socket;
        this.socketAddress = connectionSettings.getInetSocketAddress();
    }

    @Override
    public void write(InputStream data) throws IOException {
        try {
            SocketUtils.sendUdpPackages(data, this.socket.getReceiveBufferSize(), this.socketAddress, this.socket);
        }
        finally {
            data.close();
        }
    }

    @Override
    public InputStream read() throws IOException {
        DatagramPacket receivedPacket = SocketUtils.createPacket(this.socketProperties.getReceiveBufferSize());
        receivedPacket.setSocketAddress(this.socketAddress);
        try {
            this.socket.receive(receivedPacket);
            return new ByteArrayInputStream(Arrays.copyOf(receivedPacket.getData(), receivedPacket.getLength()));
        }
        catch (SocketTimeoutException e) {
            throw new ReadingTimeoutException("UDP socket timed out while waiting for a response", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public SocketAttributes getAttributes() {
        return new ImmutableSocketAttributes(this.socket);
    }
}

