/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp;

import java.net.InetSocketAddress;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.connection.AbstractSocketConnection;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.runtime.api.connection.ConnectionException;

abstract class AbstractTcpConnection
extends AbstractSocketConnection {
    protected final TcpProtocol protocol;

    public AbstractTcpConnection(SocketConnectionSettings connectionSettings, TcpProtocol protocol) {
        super(connectionSettings);
        this.protocol = protocol;
    }

    protected InetSocketAddress getSocketAddress(SocketConnectionSettings connectionSettings, boolean failOnUnresolvedHost) throws ConnectionException {
        InetSocketAddress address = connectionSettings.getInetSocketAddress();
        if (address.isUnresolved() && failOnUnresolvedHost) {
            throw new ConnectionException(String.format("Host '%s' could not be resolved", connectionSettings.getHost()));
        }
        return address;
    }
}

