/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.connection.ListenerConnection;
import org.mule.extension.socket.api.connection.tcp.AbstractTcpConnection;
import org.mule.extension.socket.api.socket.factory.SimpleServerSocketFactory;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.extension.socket.api.socket.tcp.TcpServerSocketProperties;
import org.mule.extension.socket.api.worker.SocketWorker;
import org.mule.extension.socket.api.worker.TcpWorker;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public final class TcpListenerConnection
extends AbstractTcpConnection
implements ListenerConnection {
    private final TcpServerSocketProperties socketProperties;
    private final SimpleServerSocketFactory serverSocketFactory;
    private ServerSocket serverSocket;

    public TcpListenerConnection(SocketConnectionSettings connectionSettings, TcpProtocol protocol, TcpServerSocketProperties socketProperties, SimpleServerSocketFactory serverSocketFactory) throws ConnectionException {
        super(connectionSettings, protocol);
        this.socketProperties = socketProperties;
        this.serverSocketFactory = serverSocketFactory;
    }

    @Override
    public SocketWorker listen(SourceCallback<InputStream, ImmutableSocketAttributes> callback) throws IOException, ConnectionException {
        Socket newConnection = this.acceptConnection();
        SocketUtils.configureConnection(newConnection, this.socketProperties);
        return new TcpWorker(newConnection, this.protocol, callback);
    }

    @Override
    public void doDisconnect() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.LOGGER.error("An error occurred when closing TCP listener socket", (Throwable)e);
        }
    }

    @Override
    public void connect() throws ConnectionException {
        try {
            this.serverSocket = this.serverSocketFactory.createServerSocket();
            if (this.socketProperties.getReceiveBufferSize() != null) {
                this.serverSocket.setReceiveBufferSize(this.socketProperties.getReceiveBufferSize());
            }
            if (this.socketProperties.getServerTimeout() != null) {
                this.serverSocket.setSoTimeout(this.socketProperties.getServerTimeout());
            }
            this.serverSocket.setReuseAddress(this.socketProperties.getReuseAddress());
        }
        catch (Exception e) {
            throw new ConnectionException("Could not create TCP listener socket", (Throwable)e);
        }
        InetSocketAddress address = this.getSocketAddress(this.connectionSettings, this.socketProperties.getFailOnUnresolvedHost());
        try {
            this.serverSocket.bind(address, this.socketProperties.getReceiveBacklog());
        }
        catch (IOException e) {
            throw new ConnectionException(String.format("Could not bind socket to host '%s' and port '%d'", this.connectionSettings.getHost(), this.connectionSettings.getPort()), (Throwable)e);
        }
    }

    @Override
    public ConnectionValidationResult validate() {
        if (this.serverSocket.isClosed()) {
            return ConnectionValidationResult.failure((String)"TCP server socket was closed", null);
        }
        if (!this.serverSocket.isBound()) {
            return ConnectionValidationResult.failure((String)"TCP server socket was not bounded", null);
        }
        return ConnectionValidationResult.success();
    }

    private Socket acceptConnection() throws ConnectionException, IOException {
        try {
            return this.serverSocket.accept();
        }
        catch (IOException e) {
            if (!this.wasDisconnected) {
                throw new ConnectionException("An error occurred while listening for new TCP connections", (Throwable)e);
            }
            this.LOGGER.debug("TCP listener socket has been gracefully closed");
            throw e;
        }
    }
}

