/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.udp;

import java.net.DatagramSocket;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.connection.AbstractSocketConnection;
import org.mule.extension.socket.api.socket.udp.UdpSocketProperties;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;

public abstract class AbstractUdpConnection
extends AbstractSocketConnection {
    protected final UdpSocketProperties socketProperties;
    protected DatagramSocket socket;

    public AbstractUdpConnection(SocketConnectionSettings connectionSettings, UdpSocketProperties socketProperties) throws ConnectionException {
        super(connectionSettings);
        this.socketProperties = socketProperties;
    }

    @Override
    protected void doDisconnect() {
        this.socket.close();
    }

    @Override
    public ConnectionValidationResult validate() {
        if (this.socket.isClosed()) {
            return ConnectionValidationResult.failure((String)"UDP socket was closed", null);
        }
        return ConnectionValidationResult.success();
    }

    protected DatagramSocket newSocket(SocketConnectionSettings connectionSettings) throws ConnectionException {
        try {
            return new DatagramSocket(connectionSettings.getInetSocketAddress());
        }
        catch (Exception e) {
            throw new ConnectionException(String.format("Could not bind UDP Socket to address %s", connectionSettings.toString()), (Throwable)e);
        }
    }
}

