/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.udp;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.connection.ListenerConnection;
import org.mule.extension.socket.api.connection.udp.AbstractUdpConnection;
import org.mule.extension.socket.api.exceptions.ReadingTimeoutException;
import org.mule.extension.socket.api.socket.udp.UdpSocketProperties;
import org.mule.extension.socket.api.worker.SocketWorker;
import org.mule.extension.socket.api.worker.UdpWorker;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public class UdpListenerConnection
extends AbstractUdpConnection
implements ListenerConnection {
    public UdpListenerConnection(SocketConnectionSettings connectionSettings, UdpSocketProperties socketProperties) throws ConnectionException {
        super(connectionSettings, socketProperties);
    }

    @Override
    public void connect() throws ConnectionException {
        this.socket = this.newSocket(this.connectionSettings);
        SocketUtils.configureConnection(this.socket, this.socketProperties);
    }

    @Override
    public SocketWorker listen(SourceCallback<InputStream, ImmutableSocketAttributes> sourceCallback) throws IOException, ConnectionException {
        DatagramPacket packet = SocketUtils.createPacket(this.socketProperties.getReceiveBufferSize());
        try {
            this.socket.receive(packet);
        }
        catch (SocketTimeoutException e) {
            throw new ReadingTimeoutException("UDP Source timed out while awaiting for new packages", e);
        }
        catch (IOException e) {
            if (!this.wasDisconnected) {
                throw new ConnectionException("An error occurred while listening for new UDP packets", (Throwable)e);
            }
            this.LOGGER.debug("UDP listener socket has been gracefully closed");
            throw e;
        }
        DatagramSocket newConnection = new DatagramSocket();
        SocketUtils.configureConnection(newConnection, this.socketProperties);
        return new UdpWorker(newConnection, packet, sourceCallback);
    }
}

