/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.worker;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.worker.SocketWorker;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UdpWorker
extends SocketWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpWorker.class);
    private final DatagramSocket socket;
    private final DatagramPacket packet;

    public UdpWorker(DatagramSocket socket, DatagramPacket packet, SourceCallback<InputStream, ImmutableSocketAttributes> callback) {
        super(callback);
        this.socket = socket;
        this.packet = packet;
    }

    @Override
    public void doRun() {
        ByteArrayInputStream content = new ByteArrayInputStream(Arrays.copyOf(this.packet.getData(), this.packet.getLength()));
        this.handle(content, new ImmutableSocketAttributes(this.packet));
    }

    @Override
    public void onComplete(InputStream result) {
        try {
            SocketUtils.sendUdpPackages(result, this.socket.getReceiveBufferSize(), this.packet.getSocketAddress(), this.socket);
        }
        catch (IOException e) {
            LOGGER.error(String.format("An error occurred while sending UDP packet to address '%s'", this.packet.getSocketAddress().toString()), (Throwable)e);
        }
    }

    @Override
    public void onError(Throwable e) {
        LOGGER.error("UDP worker will not answer back due an exception was received", e);
    }

    public void dispose() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                LOGGER.error("UDP worker failed closing socket", (Throwable)e);
            }
        }
    }
}

