/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.extension.socket.api.connection.AbstractSocketConnection;
import org.mule.extension.socket.api.exceptions.UnresolvableHostException;
import org.mule.extension.socket.api.socket.tcp.TcpSocketProperties;
import org.mule.extension.socket.api.socket.udp.UdpSocketProperties;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class SocketUtils {
    private static final String SOCKET_COULD_NOT_BE_CREATED = "%s Socket could not be created correctly";
    public static final String WORK = "work";

    private SocketUtils() {
    }

    public static ConnectionValidationResult validate(AbstractSocketConnection connection) {
        return connection.validate();
    }

    public static Result<InputStream, ImmutableSocketAttributes> createResult(InputStream content, ImmutableSocketAttributes attributes) {
        return Result.builder().output((Object)content).attributes((Object)attributes).build();
    }

    public static DatagramPacket createPacket(byte[] content) throws UnresolvableHostException {
        return new DatagramPacket(content, content.length);
    }

    public static DatagramPacket createPacket(byte[] content, int dataLength) throws UnresolvableHostException {
        return new DatagramPacket(content, dataLength);
    }

    public static DatagramPacket createPacket(int bufferSize) throws UnresolvableHostException {
        return new DatagramPacket(new byte[bufferSize], bufferSize);
    }

    public static void configureConnection(DatagramSocket socket, UdpSocketProperties socketProperties) throws ConnectionException {
        Preconditions.checkArgument((socket != null ? 1 : 0) != 0, (String)"Null socket found. UDP Socket must be created before being configured");
        try {
            if (socketProperties.getSendBufferSize() != null) {
                socket.setSendBufferSize(socketProperties.getSendBufferSize());
            }
            if (socketProperties.getReceiveBufferSize() != null) {
                socket.setReceiveBufferSize(socketProperties.getReceiveBufferSize());
            }
            if (socketProperties.getClientTimeout() != null) {
                socket.setSoTimeout(socketProperties.getClientTimeout());
            }
            socket.setBroadcast(socketProperties.getBroadcast());
            socket.setReuseAddress(socketProperties.getReuseAddress());
        }
        catch (Exception e) {
            throw new ConnectionException(String.format(SOCKET_COULD_NOT_BE_CREATED, "UDP"), (Throwable)e);
        }
    }

    public static void configureConnection(Socket socket, TcpSocketProperties socketProperties) throws ConnectionException {
        try {
            if (socketProperties.getSendBufferSize() != null) {
                socket.setSendBufferSize(socketProperties.getSendBufferSize());
            }
            if (socketProperties.getReceiveBufferSize() != null) {
                socket.setReceiveBufferSize(socketProperties.getReceiveBufferSize());
            }
            if (socketProperties.getClientTimeout() != null) {
                socket.setSoTimeout(socketProperties.getClientTimeout());
            }
            if (socketProperties.getKeepAlive()) {
                socket.setKeepAlive(socketProperties.getKeepAlive());
            }
            if (socketProperties.getLinger() != null) {
                socket.setSoLinger(true, socketProperties.getLinger());
            }
        }
        catch (SocketException e) {
            throw new ConnectionException(String.format(SOCKET_COULD_NOT_BE_CREATED, "TCP"), (Throwable)e);
        }
        try {
            socket.setTcpNoDelay(socketProperties.getSendTcpNoDelay());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public static void sendUdpPackages(InputStream inputStream, int bufferSize, SocketAddress address, DatagramSocket socket) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int chunkLen = 0;
        while ((chunkLen = inputStream.read(buffer, 0, buffer.length)) != -1) {
            DatagramPacket sendPacket = SocketUtils.createPacket(buffer, chunkLen);
            sendPacket.setSocketAddress(address);
            socket.send(sendPacket);
        }
    }
}

