/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.util.List;
import java.util.Map;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.FormValidatorStrategy;
import org.mule.module.apikit.validation.body.form.transformation.DataWeaveTransformer;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.el.ExpressionManager;

public class UrlencodedFormV1Validator
implements FormValidatorStrategy<TypedValue> {
    Map<String, List<IParameter>> formParameters;
    DataWeaveTransformer dataWeaveTransformer;

    public UrlencodedFormV1Validator(Map<String, List<IParameter>> formParameters, ExpressionManager expressionManager) {
        this.formParameters = formParameters;
        this.dataWeaveTransformer = new DataWeaveTransformer(expressionManager);
    }

    @Override
    public TypedValue validate(TypedValue originalPayload) throws BadRequestException {
        MultiMap<String, String> requestMap = this.dataWeaveTransformer.getMultiMapFromPayload(originalPayload);
        for (String expectedKey : this.formParameters.keySet()) {
            if (this.formParameters.get(expectedKey).size() != 1) continue;
            IParameter expected = this.formParameters.get(expectedKey).get(0);
            Object actual = requestMap.get((Object)expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidFormParameterException("Required form parameter " + expectedKey + " not specified");
            }
            if (actual == null && expected.getDefaultValue() != null) {
                requestMap.put((Object)expectedKey, (Object)expected.getDefaultValue());
            }
            if (actual == null || !(actual instanceof String) || expected.validate((String)actual)) continue;
            String msg = String.format("Invalid value '%s' for form parameter %s. %s", actual, expectedKey, expected.message((String)actual));
            throw new InvalidFormParameterException(msg);
        }
        return this.dataWeaveTransformer.getXFormUrlEncodedStream(requestMap, originalPayload.getDataType());
    }
}

