/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.io.IOException;
import java.net.UnknownHostException;
import javax.inject.Inject;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.MutableThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.listener.HttpListenerConfig;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.listener.HttpListenerConnectionManager;
import org.mule.module.http.internal.listener.ListenerPath;
import org.mule.module.http.internal.listener.RequestHandlerManager;
import org.mule.module.http.internal.listener.Server;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.matcher.ListenerRequestMatcher;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.tcp.DefaultTcpServerSocketProperties;
import org.mule.transport.tcp.TcpServerSocketProperties;
import org.mule.util.NetworkUtils;
import org.mule.util.Preconditions;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.ThreadNameHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpListenerConfig
implements HttpListenerConfig,
Initialisable,
MuleContextAware {
    public static final int DEFAULT_MAX_THREADS = 128;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_CONNECTION_IDLE_TIMEOUT = 30000;
    private HttpConstants.Protocols protocol = HttpConstants.Protocols.HTTP;
    private String name;
    private String host;
    private Integer port;
    private String basePath;
    private Boolean parseRequest;
    private MuleContext muleContext;
    @Inject
    private HttpListenerConnectionManager connectionManager;
    private TlsContextFactory tlsContext;
    private TcpServerSocketProperties serverSocketProperties = new DefaultTcpServerSocketProperties();
    private ThreadingProfile workerThreadingProfile;
    private boolean started = false;
    private Server server;
    private WorkManager workManager;
    private boolean initialised;
    private boolean usePersistentConnections = true;
    private int connectionIdleTimeout = 30000;

    public DefaultHttpListenerConfig() {
    }

    DefaultHttpListenerConfig(HttpListenerConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setWorkerThreadingProfile(ThreadingProfile workerThreadingProfile) {
        this.workerThreadingProfile = workerThreadingProfile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProtocol(HttpConstants.Protocols protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setTlsContext(TlsContextFactory tlsContext) {
        this.tlsContext = tlsContext;
    }

    public void setServerSocketProperties(TcpServerSocketProperties serverSocketProperties) {
        this.serverSocketProperties = serverSocketProperties;
    }

    public void setParseRequest(Boolean parseRequest) {
        this.parseRequest = parseRequest;
    }

    public ListenerPath getFullListenerPath(String listenerPath) {
        Preconditions.checkArgument((boolean)listenerPath.startsWith("/"), (String)"listenerPath must start with /");
        return new ListenerPath(this.basePath, listenerPath);
    }

    public synchronized void initialise() throws InitialisationException {
        ServerAddress serverAddress;
        if (this.initialised) {
            return;
        }
        this.basePath = HttpParser.sanitizePathWithStartSlash(this.basePath);
        if (this.workerThreadingProfile == null) {
            this.workerThreadingProfile = new MutableThreadingProfile(ThreadingProfile.DEFAULT_THREADING_PROFILE);
            this.workerThreadingProfile.setMaxThreadsActive(128);
        }
        if (this.port == null) {
            this.port = this.protocol.getDefaultPort();
        }
        if (this.protocol.equals((Object)HttpConstants.Protocols.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP. If you defined a tls:context element in your listener-config then you must set protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (this.protocol.equals((Object)HttpConstants.Protocols.HTTPS) && this.tlsContext == null) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Configured protocol is HTTPS but there's no TlsContext configured"), (Initialisable)this);
        }
        if (this.tlsContext != null && !this.tlsContext.isKeyStoreConfigured()) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        this.verifyConnectionsParameters();
        try {
            serverAddress = this.createServerAddress();
        }
        catch (UnknownHostException e) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Cannot resolve host %s", (Object[])new Object[]{this.host}), (Throwable)e, (Initialisable)this);
        }
        this.server = this.tlsContext == null ? this.connectionManager.createServer(serverAddress, this.createWorkManagerSource(), this.usePersistentConnections, this.connectionIdleTimeout) : this.connectionManager.createSslServer(serverAddress, this.createWorkManagerSource(), this.tlsContext, this.usePersistentConnections, this.connectionIdleTimeout);
        this.initialised = true;
    }

    private WorkManagerSource createWorkManagerSource() {
        return new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return DefaultHttpListenerConfig.this.workManager;
            }
        };
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (!this.usePersistentConnections) {
            this.connectionIdleTimeout = 0;
        }
    }

    private WorkManager createWorkManager() {
        WorkManager workManager = this.workerThreadingProfile.createWorkManager(String.format("%s%s.%s", ThreadNameHelper.getPrefix((MuleContext)this.muleContext), this.name, "worker"), this.muleContext.getConfiguration().getShutdownTimeout());
        if (workManager instanceof MuleContextAware) {
            ((MuleContextAware)workManager).setMuleContext(this.muleContext);
        }
        return workManager;
    }

    private ServerAddress createServerAddress() throws UnknownHostException {
        return new ServerAddress(NetworkUtils.getLocalHostIp((String)this.host), this.port);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public RequestHandlerManager addRequestHandler(ListenerRequestMatcher requestMatcher, RequestHandler requestHandler) throws IOException {
        return this.server.addRequestHandler(requestMatcher, requestHandler);
    }

    public Boolean resolveParseRequest(Boolean listenerParseRequest) {
        return listenerParseRequest != null ? listenerParseRequest : (this.parseRequest != null ? this.parseRequest : true);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    @Override
    public synchronized void start() throws MuleException {
        if (this.started) {
            return;
        }
        try {
            this.workManager = this.createWorkManager();
            this.workManager.start();
            this.server.start();
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        this.started = true;
        this.logger.info("Listening for requests on " + this.listenerUrl());
    }

    @Override
    public boolean hasTlsConfig() {
        return this.tlsContext != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws MuleException {
        if (this.started) {
            try {
                this.workManager.dispose();
            }
            catch (Exception e) {
                this.logger.warn("Failure shutting down work manager " + e.getMessage());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.workManager = null;
            }
            this.server.stop();
            this.started = false;
            this.logger.info("Stopped listener on " + this.listenerUrl());
        }
    }

    private String listenerUrl() {
        return String.format("%s://%s:%d%s", this.protocol.getScheme(), this.getHost(), this.getPort(), StringUtils.defaultString((String)this.basePath));
    }

    public String getName() {
        return this.name;
    }

    WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setUsePersistentConnections(boolean usePersistentConnections) {
        this.usePersistentConnections = usePersistentConnections;
    }

    public void setConnectionIdleTimeout(int connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }
}

