/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.listener.ListenerPath;

public class HttpMessagePropertiesResolver {
    private String uri;
    private String method;
    private String protocol;
    private String remoteHostAddress;
    private ListenerPath listenerPath;
    private String scheme;
    private Certificate clientCertificate;

    public HttpMessagePropertiesResolver setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public HttpMessagePropertiesResolver setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpMessagePropertiesResolver setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public HttpMessagePropertiesResolver setRemoteHostAddress(String remoteHostAddress) {
        this.remoteHostAddress = remoteHostAddress;
        return this;
    }

    public HttpMessagePropertiesResolver setListenerPath(ListenerPath listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public HttpMessagePropertiesResolver setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpMessagePropertiesResolver setClientCertificate(Certificate clientCertificate) {
        this.clientCertificate = clientCertificate;
        return this;
    }

    public void addPropertiesTo(Map<String, Object> propertiesMap) {
        String resolvedListenerPath = this.listenerPath.getResolvedPath();
        propertiesMap.put("http.method", this.method);
        String path = HttpParser.extractPath(this.uri);
        String rawQueryString = HttpParser.extractQueryParams(this.uri);
        ParameterMap queryParams = HttpParser.decodeQueryString(rawQueryString);
        propertiesMap.put("http.query.params", queryParams == null ? Collections.emptyMap() : queryParams.toImmutableParameterMap());
        propertiesMap.put("http.query.string", rawQueryString);
        propertiesMap.put("http.request.path", path);
        propertiesMap.put("http.version", this.protocol);
        propertiesMap.put("http.request.uri", this.uri);
        propertiesMap.put("http.remote.address", this.remoteHostAddress);
        propertiesMap.put("http.uri.params", HttpParser.decodeUriParams(resolvedListenerPath, path));
        propertiesMap.put("http.listener.path", resolvedListenerPath);
        propertiesMap.put("http.relative.path", this.listenerPath.getRelativePath(path));
        propertiesMap.put("http.scheme", this.scheme);
        if (this.clientCertificate != null) {
            propertiesMap.put("http.client.cert", this.clientCertificate);
        }
    }
}

