/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.mule.api.DefaultMuleException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.module.http.internal.listener.grizzly.BaseResponseCompletionHandler;

public class ResponseStreamingCompletionHandler
extends BaseResponseCompletionHandler {
    private final MemoryManager memoryManager;
    private final FilterChainContext ctx;
    private final HttpResponsePacket httpResponsePacket;
    private final InputStream inputStream;
    private final ResponseStatusCallback responseStatusCallback;
    private volatile boolean isDone;

    public ResponseStreamingCompletionHandler(FilterChainContext ctx, HttpRequestPacket request, HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
        Preconditions.checkArgument((boolean)(httpResponse.getEntity() instanceof InputStreamHttpEntity), (Object)"http response must have an input stream entity");
        this.ctx = ctx;
        this.httpResponsePacket = this.buildHttpResponsePacket(request, httpResponse);
        this.inputStream = ((InputStreamHttpEntity)httpResponse.getEntity()).getInputStream();
        this.memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        this.responseStatusCallback = responseStatusCallback;
    }

    public void start() throws IOException {
        this.sendInputStreamChunk();
    }

    public void sendInputStreamChunk() throws IOException {
        HttpTrailer content;
        int length;
        int offset;
        Buffer buffer = this.memoryManager.allocate(8192);
        byte[] bufferByteArray = buffer.array();
        int bytesRead = this.inputStream.read(bufferByteArray, offset = buffer.arrayOffset(), length = buffer.remaining());
        if (bytesRead == -1) {
            content = this.httpResponsePacket.httpTrailerBuilder().build();
            this.isDone = true;
        } else {
            buffer.limit(bytesRead);
            content = this.httpResponsePacket.httpContentBuilder().content(buffer).build();
        }
        this.ctx.write((Object)content, (CompletionHandler)this);
    }

    public void completed(WriteResult result) {
        try {
            if (!this.isDone) {
                this.sendInputStreamChunk();
                if (this.isDone && !this.httpResponsePacket.isChunked()) {
                    this.doComplete();
                }
            } else {
                this.doComplete();
            }
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    private void doComplete() {
        this.close();
        this.responseStatusCallback.responseSendSuccessfully();
        this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        this.resume();
    }

    public void cancelled() {
        this.close();
        this.responseStatusCallback.responseSendFailure((Throwable)new DefaultMuleException(CoreMessages.createStaticMessage((String)"Http response sending task was cancelled")));
        this.resume();
    }

    public void failed(Throwable throwable) {
        this.close();
        this.responseStatusCallback.responseSendFailure(throwable);
        this.resume();
    }

    private void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resume() {
        this.ctx.resume(this.ctx.getStopAction());
    }
}

