/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.client;

import org.mule.MessageExchangePattern;
import org.mule.api.client.OperationOptions;
import org.mule.util.Preconditions;

public class HttpRequestCacheKey<OptionsType extends OperationOptions> {
    private final String url;
    private final OptionsType operationOptions;
    private final MessageExchangePattern exchangePattern;

    public HttpRequestCacheKey(String url, OptionsType operationOptions, MessageExchangePattern exchangePattern) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"URL cannot be null");
        Preconditions.checkArgument((operationOptions != null ? 1 : 0) != 0, (String)"Operation options cannot be null");
        Preconditions.checkArgument((exchangePattern != null ? 1 : 0) != 0, (String)"Exchange pattern cannot be null");
        this.url = url;
        this.operationOptions = operationOptions;
        this.exchangePattern = exchangePattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRequestCacheKey)) {
            return false;
        }
        HttpRequestCacheKey that = (HttpRequestCacheKey)o;
        if (!this.operationOptions.equals(that.operationOptions)) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        return this.exchangePattern == that.exchangePattern;
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.operationOptions.hashCode();
        result = 31 * result + this.exchangePattern.hashCode();
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public OptionsType getOperationOptions() {
        return this.operationOptions;
    }

    public MessageExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }
}

