/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.mule.api.CompletionHandler;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.request.DefaultHttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.module.http.internal.request.HttpAuthenticationType;
import org.mule.module.http.internal.request.HttpClient;
import org.mule.module.http.internal.request.HttpClientConfiguration;
import org.mule.module.http.internal.request.NtlmProxyConfig;
import org.mule.module.http.internal.request.grizzly.CompositeTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.CustomTimeoutThrottleRequestFilter;
import org.mule.module.http.internal.request.grizzly.IOStrategyTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.LoggerTransportCustomizer;
import org.mule.module.http.internal.request.grizzly.SocketConfigTransportCustomizer;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.ssl.api.TlsContextTrustStoreConfiguration;
import org.mule.transport.tcp.TcpClientSocketProperties;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpClient
implements HttpClient {
    private static final int MAX_CONNECTION_LIFETIME = 1800000;
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpClient.class);
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private int maxConnections;
    private boolean usePersistentConnections;
    private int connectionIdleTimeout;
    private String threadNamePrefix;
    private String ownerName;
    private AsyncHttpClient asyncHttpClient;
    private SSLContext sslContext;

    public GrizzlyHttpClient(HttpClientConfiguration config) {
        this.tlsContextFactory = config.getTlsContextFactory();
        this.proxyConfig = config.getProxyConfig();
        this.clientSocketProperties = config.getClientSocketProperties();
        this.maxConnections = config.getMaxConnections();
        this.usePersistentConnections = config.isUsePersistentConnections();
        this.connectionIdleTimeout = config.getConnectionIdleTimeout();
        this.threadNamePrefix = config.getThreadNamePrefix();
        this.ownerName = config.getOwnerName();
    }

    public void initialise() throws InitialisationException {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setAllowPoolingConnections(true);
        this.configureTransport(builder);
        this.configureTlsContext(builder);
        this.configureProxy(builder);
        this.configureConnections(builder);
        AsyncHttpClientConfig config = builder.build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    private void configureTlsContext(AsyncHttpClientConfig.Builder builder) throws InitialisationException {
        if (this.tlsContextFactory != null) {
            TlsContextTrustStoreConfiguration trustStoreConfiguration;
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
            try {
                this.sslContext = this.tlsContextFactory.createSslContext();
            }
            catch (Exception e) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"Cannot initialize SSL context"), (Throwable)e, (Initialisable)this);
            }
            builder.setSSLContext(this.sslContext);
            if (this.tlsContextFactory.getEnabledCipherSuites() != null) {
                builder.setEnabledCipherSuites(this.tlsContextFactory.getEnabledCipherSuites());
            }
            if (this.tlsContextFactory.getEnabledProtocols() != null) {
                builder.setEnabledProtocols(this.tlsContextFactory.getEnabledProtocols());
            }
            if ((trustStoreConfiguration = this.tlsContextFactory.getTrustStoreConfiguration()) != null && trustStoreConfiguration.isInsecure()) {
                logger.warn(String.format("TLS configuration for requester %s has been set to use an insecure trust store. This means no certificate validations will be performed, rendering connections vulnerable to attacks. Use at own risk.", this.ownerName));
                builder.setAcceptAnyCertificate(true);
            }
        }
    }

    private void configureProxy(AsyncHttpClientConfig.Builder builder) {
        if (this.proxyConfig != null) {
            this.doConfigureProxy(builder, this.proxyConfig);
        }
    }

    protected void doConfigureProxy(AsyncHttpClientConfig.Builder builder, ProxyConfig proxyConfig) {
        builder.setProxyServer(this.buildProxy(proxyConfig));
    }

    protected final ProxyServer buildProxy(ProxyConfig proxyConfig) {
        ProxyServer proxyServer;
        if (!StringUtils.isEmpty((String)proxyConfig.getUsername())) {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            if (proxyConfig instanceof NtlmProxyConfig) {
                proxyServer.setNtlmDomain(((NtlmProxyConfig)proxyConfig).getNtlmDomain());
                try {
                    proxyServer.setNtlmHost(this.getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                proxyServer.setScheme(Realm.AuthScheme.NTLM);
            }
        } else {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort());
        }
        return proxyServer;
    }

    private void configureTransport(AsyncHttpClientConfig.Builder builder) {
        GrizzlyAsyncHttpProviderConfig providerConfig = new GrizzlyAsyncHttpProviderConfig();
        CompositeTransportCustomizer compositeTransportCustomizer = new CompositeTransportCustomizer();
        compositeTransportCustomizer.addTransportCustomizer(new IOStrategyTransportCustomizer(this.threadNamePrefix));
        compositeTransportCustomizer.addTransportCustomizer(new LoggerTransportCustomizer());
        if (this.clientSocketProperties != null) {
            compositeTransportCustomizer.addTransportCustomizer(new SocketConfigTransportCustomizer(this.clientSocketProperties));
        }
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER, (Object)compositeTransportCustomizer);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.DECOMPRESS_RESPONSE, (Object)Boolean.FALSE);
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
    }

    private void configureConnections(AsyncHttpClientConfig.Builder builder) throws InitialisationException {
        if (this.maxConnections > 0) {
            builder.addRequestFilter((RequestFilter)new CustomTimeoutThrottleRequestFilter(this.maxConnections));
        }
        builder.setMaxConnections(this.maxConnections);
        builder.setMaxConnectionsPerHost(this.maxConnections);
        builder.setAllowPoolingConnections(this.usePersistentConnections);
        builder.setAllowPoolingSslConnections(this.usePersistentConnections);
        builder.setConnectionTTL(1800000);
        builder.setPooledConnectionIdleTimeout(this.connectionIdleTimeout);
        builder.setIOThreadMultiplier(1);
    }

    @Override
    public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication);
        ListenableFuture future = this.asyncHttpClient.executeRequest(grizzlyRequest);
        try {
            Response response = (Response)future.get();
            if (response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Null response returned by async client");
                }
                response = (Response)future.get();
            }
            return this.createMuleResponse(response);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Override
    public void send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication, CompletionHandler<HttpResponse, Exception> completionHandler, WorkManager workManager) {
        try {
            this.asyncHttpClient.executeRequest(this.createGrizzlyRequest(request, responseTimeout, followRedirects, authentication), (AsyncHandler)new WorkManagerSourceAsyncCompletionHandler(completionHandler, workManager));
        }
        catch (Exception e) {
            completionHandler.onFailure((Throwable)e);
        }
    }

    private HttpResponse createMuleResponse(Response response) throws IOException {
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        responseBuilder.setStatusCode(response.getStatusCode());
        responseBuilder.setReasonPhrase(response.getStatusText());
        responseBuilder.setEntity(new InputStreamHttpEntity(response.getResponseBodyAsStream()));
        if (response.hasResponseHeaders()) {
            for (String header : response.getHeaders().keySet()) {
                for (String headerValue : response.getHeaders(header)) {
                    responseBuilder.addHeader(header, headerValue);
                }
            }
        }
        return responseBuilder.build();
    }

    private Request createGrizzlyRequest(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication) throws IOException {
        RequestBuilder builder = this.createRequestBuilder(request);
        builder.setMethod(request.getMethod());
        builder.setUrl(request.getUri());
        builder.setFollowRedirects(followRedirects);
        this.populateHeaders(request, builder);
        DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)request;
        for (String queryParamName : defaultHttpRequest.getQueryParams().keySet()) {
            for (String queryParamValue : defaultHttpRequest.getQueryParams().getAll(queryParamName)) {
                builder.addQueryParam(queryParamName, queryParamValue);
            }
        }
        if (authentication != null) {
            Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().setPrincipal(authentication.getUsername()).setPassword(authentication.getPassword()).setUsePreemptiveAuth(authentication.isPreemptive());
            if (authentication.getType() == HttpAuthenticationType.BASIC) {
                realmBuilder.setScheme(Realm.AuthScheme.BASIC);
            } else if (authentication.getType() == HttpAuthenticationType.DIGEST) {
                realmBuilder.setScheme(Realm.AuthScheme.DIGEST);
            } else if (authentication.getType() == HttpAuthenticationType.NTLM) {
                String workstation;
                String domain = authentication.getDomain();
                if (domain != null) {
                    realmBuilder.setNtlmDomain(domain);
                }
                String ntlmHost = (workstation = authentication.getWorkstation()) != null ? workstation : this.getHostName();
                realmBuilder.setNtlmHost(ntlmHost).setScheme(Realm.AuthScheme.NTLM);
            }
            builder.setRealm(realmBuilder.build());
        }
        if (request.getEntity() != null) {
            if (request.getEntity() instanceof InputStreamHttpEntity) {
                builder.setBody((BodyGenerator)new InputStreamBodyGenerator(((InputStreamHttpEntity)request.getEntity()).getInputStream()));
            } else if (request.getEntity() instanceof ByteArrayHttpEntity) {
                builder.setBody(((ByteArrayHttpEntity)request.getEntity()).getContent());
            } else if (request.getEntity() instanceof MultipartHttpEntity) {
                MultipartHttpEntity multipartHttpEntity = (MultipartHttpEntity)request.getEntity();
                for (HttpPart part : multipartHttpEntity.getParts()) {
                    if (part.getFileName() != null) {
                        builder.addBodyPart((Part)new ByteArrayPart(part.getName(), IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), null, part.getFileName()));
                        continue;
                    }
                    byte[] content = IOUtils.toByteArray((InputStream)part.getInputStream());
                    builder.addBodyPart((Part)new ByteArrayPart(part.getName(), content, part.getContentType(), null));
                }
            }
        }
        builder.setRequestTimeout(responseTimeout);
        return builder.build();
    }

    protected RequestBuilder createRequestBuilder(HttpRequest request) {
        return new RequestBuilder();
    }

    protected void populateHeaders(HttpRequest request, RequestBuilder builder) {
        for (String headerName : request.getHeaderNames()) {
            for (String headerValue : request.getHeaderValues(headerName)) {
                builder.addHeader(headerName, headerValue);
            }
        }
        if (!this.usePersistentConnections) {
            String connectionHeaderValue = request.getHeaderValueIgnoreCase("Connection");
            if (connectionHeaderValue != null && !"close".equals(connectionHeaderValue) && logger.isDebugEnabled()) {
                logger.debug("Persistent connections are disabled in the HTTP requester configuration, but the request already contains a Connection header with value {}. This header will be ignored, and a Connection: close header will be sent instead.", (Object)connectionHeaderValue);
            }
            builder.setHeader("Connection", "close");
        }
    }

    private String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    protected ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void stop() {
        this.asyncHttpClient.close();
    }

    private class WorkManagerSourceAsyncCompletionHandler
    extends AsyncCompletionHandler<Response>
    implements WorkManagerSource {
        private CompletionHandler<HttpResponse, Exception> completionHandler;
        private WorkManager workManager;

        WorkManagerSourceAsyncCompletionHandler(CompletionHandler<HttpResponse, Exception> completionHandler, WorkManager workManager) {
            this.completionHandler = completionHandler;
            this.workManager = workManager;
        }

        public Response onCompleted(Response response) throws Exception {
            this.completionHandler.onCompletion((Object)GrizzlyHttpClient.this.createMuleResponse(response));
            return null;
        }

        public void onThrowable(Throwable t) {
            this.completionHandler.onFailure((Throwable)((Exception)t));
        }

        public WorkManager getWorkManager() throws MuleException {
            return this.workManager;
        }
    }
}

