/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class TimeValidator
extends AbstractValidator {
    private final String time;
    private final String locale;
    private final String pattern;
    private I18nMessage errorMessage;

    public TimeValidator(String time, String locale, String pattern, ValidationContext validationContext) {
        super(validationContext);
        this.time = time;
        this.locale = locale;
        this.pattern = pattern;
    }

    @Override
    public ValidationResult validate() {
        Locale locale = new Locale(this.locale);
        try {
            DateTimeFormatter.ofPattern(this.pattern).withLocale(locale).parse(this.time);
        }
        catch (DateTimeParseException e) {
            this.errorMessage = this.getMessages().invalidTime(this.time, this.locale, this.pattern);
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.INVALID_TIME;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

