/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.handler;

import java.util.List;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.SchemaHandler;

public class ArrayHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ArraySchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        Schema arrayType;
        String title;
        ArraySchema arraySchema = (ArraySchema)schema;
        if (arraySchema.getItemSchemas() != null && !arraySchema.getItemSchemas().isEmpty()) {
            String title2;
            List itemSchemas = arraySchema.getItemSchemas();
            TupleTypeBuilder tupleType = root.tupleType();
            String description = arraySchema.getDescription();
            if (StringUtils.isNotEmpty((String)description)) {
                tupleType.description(description);
            }
            if (StringUtils.isNotEmpty((String)(title2 = arraySchema.getTitle()))) {
                tupleType.label(title2);
            }
            for (Schema itemSchema : itemSchemas) {
                tupleType.of(handlerManager.handle(itemSchema, parsingContext));
            }
            return tupleType;
        }
        ArrayTypeBuilder arrayMetadataBuilder = root.arrayType();
        String description = arraySchema.getDescription();
        if (StringUtils.isNotEmpty((String)description)) {
            arrayMetadataBuilder.description(description);
        }
        if (StringUtils.isNotEmpty((String)(title = arraySchema.getTitle()))) {
            arrayMetadataBuilder.label(title);
        }
        if (arraySchema.needsUniqueItems()) {
            arrayMetadataBuilder.uniques();
        }
        Integer min = null;
        Integer max = null;
        if (arraySchema.getMinItems() != null && arraySchema.getMinItems() > 0) {
            min = arraySchema.getMinItems();
        }
        if (arraySchema.getMaxItems() != null && arraySchema.getMaxItems() > 0) {
            max = arraySchema.getMaxItems();
        }
        if (MetadataTypeUtils.isNotNull(min) || MetadataTypeUtils.isNotNull(max)) {
            arrayMetadataBuilder.boundary((Number)min, (Number)max);
        }
        if ((arrayType = arraySchema.getAllItemSchema()) != null) {
            arrayMetadataBuilder.of(handlerManager.handle(arrayType, parsingContext));
        } else {
            arrayMetadataBuilder.of().anyType();
        }
        return arrayMetadataBuilder;
    }
}

