/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleException;
import org.mule.api.transformer.wire.WireFormat;

class MuleMessageWorker {
    private final WireFormat wireFormat;

    MuleMessageWorker(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public byte[] doWrite() throws IOException {
        DefaultMuleMessage msg = (DefaultMuleMessage)RequestContext.getEvent().getMessage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.wireFormat.write((OutputStream)baos, (Object)msg, msg.getEncoding());
        }
        catch (MuleException e) {
            throw new IOException(e.getDetailedMessage());
        }
        return baos.toByteArray();
    }

    public Object doRead(Object message) throws IOException {
        if (message == null) {
            return null;
        }
        InputStream in = message instanceof byte[] ? new ByteArrayInputStream((byte[])message) : (InputStream)message;
        try {
            return this.wireFormat.read(in);
        }
        catch (MuleException e) {
            throw new IOException(e.getDetailedMessage());
        }
    }
}

