/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 
 */

package org.opensaml.saml.saml2.core.impl;

import java.util.List;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.common.AbstractSAMLObject;
import org.opensaml.saml.saml2.core.NameIDPolicy;

/**
 * Concrete implementation of {@link org.opensaml.saml.saml2.core.NameIDPolicy}.
 */
public class NameIDPolicyImpl extends AbstractSAMLObject implements NameIDPolicy {

    /** NameID Format URI. */
    private String format;

    /** NameID Format URI. */
    private String spNameQualifier;

    /** NameID Format URI. */
    private XSBooleanValue allowCreate;

    /**
     * Constructor.
     * 
     * @param namespaceURI the namespace the element is in
     * @param elementLocalName the local name of the XML element this Object represents
     * @param namespacePrefix the prefix for the given namespace
     */
    protected NameIDPolicyImpl(final String namespaceURI, final String elementLocalName, final String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /** {@inheritDoc} */
    public String getFormat() {
        return format;
    }

    /** {@inheritDoc} */
    public void setFormat(final String newFormat) {
        format = prepareForAssignment(format, newFormat);

    }

    /** {@inheritDoc} */
    public String getSPNameQualifier() {
        return spNameQualifier;
    }

    /** {@inheritDoc} */
    public void setSPNameQualifier(final String newSPNameQualifier) {
        spNameQualifier = prepareForAssignment(spNameQualifier, newSPNameQualifier);

    }
    
    /** {@inheritDoc} */
    public Boolean getAllowCreate(){
        if(allowCreate != null){
            return allowCreate.getValue();
        }
        
        return Boolean.FALSE;
    }

    /** {@inheritDoc} */
    public XSBooleanValue getAllowCreateXSBoolean() {
        return allowCreate;
    }

    /** {@inheritDoc} */
    public void setAllowCreate(final Boolean newAllowCreate){
        if(newAllowCreate != null){
            allowCreate = prepareForAssignment(allowCreate, new XSBooleanValue(newAllowCreate, false));
        }else{
            allowCreate = prepareForAssignment(allowCreate, null);
        }
    }
    
    /** {@inheritDoc} */
    public void setAllowCreate(final XSBooleanValue newAllowCreate) {
        allowCreate = prepareForAssignment(allowCreate, newAllowCreate);

    }

    /** {@inheritDoc} */
    public List<XMLObject> getOrderedChildren() {
        // no children
        return null;
    }
}