/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.function;

import org.organicdesign.fp.function.Fn0;

public class LazyRef<T>
implements Fn0<T> {
    private Fn0<T> producer;
    private T value;

    private LazyRef(Fn0<T> p) {
        this.producer = p;
    }

    public static <T> LazyRef<T> of(Fn0<T> producer) {
        if (producer == null) {
            throw new IllegalArgumentException("The producer function cannot be null (the value it returns can)");
        }
        return new LazyRef<T>(producer);
    }

    @Override
    public synchronized T applyEx() {
        if (this.producer != null) {
            this.value = this.producer.apply();
            this.producer = null;
        }
        return this.value;
    }

    public String toString() {
        return "LazyRef(" + (this.producer == null ? this.value : "*not-computed-yet*") + ")";
    }
}

