/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.event.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;

public class EventService
implements IEventService {
    private boolean available = false;
    private Map<String, IEventDispatcher> ids2dispatchers = new HashMap<String, IEventDispatcher>();
    private Map<IEventListener, String> listeners2regexps = new HashMap<IEventListener, String>();
    private Map<IEventDispatcher, Map<String, Set<IEventListener>>> dispatchers2ids2listeners = new HashMap<IEventDispatcher, Map<String, Set<IEventListener>>>();
    private Map<IEventDispatcher, Map<IEventListener, Set<String>>> dispatchers2listeners2ids = new HashMap<IEventDispatcher, Map<IEventListener, Set<String>>>();

    public synchronized void start() {
        if (!this.available) {
            this.available = true;
            for (Map.Entry<IEventDispatcher, Map<IEventListener, Set<String>>> entry : this.dispatchers2listeners2ids.entrySet()) {
                IEventDispatcher dispatcher = entry.getKey();
                Set<IEventListener> listeners = entry.getValue().keySet();
                for (IEventListener listener : listeners) {
                    dispatcher.addListener(listener);
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.available) {
            this.available = false;
            for (Map.Entry<IEventDispatcher, Map<IEventListener, Set<String>>> entry : this.dispatchers2listeners2ids.entrySet()) {
                IEventDispatcher dispatcher = entry.getKey();
                Set<IEventListener> listeners = entry.getValue().keySet();
                for (IEventListener listener : listeners) {
                    dispatcher.removeListener(listener);
                }
            }
        }
    }

    public synchronized IEventDispatcher getDispatcher(String id) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        return this.ids2dispatchers.get(id);
    }

    public synchronized void registerDispatcher(String id, IEventDispatcher dispatcher) {
        Map<String, Set<IEventListener>> ids2listeners;
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.unregisterDispatcher(id);
        this.ids2dispatchers.put(id, dispatcher);
        Map<IEventListener, Set<String>> listeners2ids = this.dispatchers2listeners2ids.get(dispatcher);
        if (listeners2ids == null) {
            listeners2ids = new HashMap<IEventListener, Set<String>>();
            this.dispatchers2listeners2ids.put(dispatcher, listeners2ids);
        }
        if ((ids2listeners = this.dispatchers2ids2listeners.get(dispatcher)) == null) {
            ids2listeners = new HashMap<String, Set<IEventListener>>();
            this.dispatchers2ids2listeners.put(dispatcher, ids2listeners);
        }
        HashSet<IEventListener> listeners = new HashSet<IEventListener>();
        ids2listeners.put(id, listeners);
        for (Map.Entry<IEventListener, String> entry : this.listeners2regexps.entrySet()) {
            IEventListener listener = entry.getKey();
            String regexp = entry.getValue();
            if (!id.matches(regexp)) continue;
            Set<String> ids = listeners2ids.get(listener);
            if (ids == null) {
                ids = new HashSet<String>();
                listeners2ids.put(listener, ids);
                dispatcher.addListener(listener);
            }
            ids.add(id);
            listeners.add(listener);
        }
    }

    public synchronized void unregisterDispatcher(String id) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IEventDispatcher dispatcher = this.ids2dispatchers.remove(id);
        if (dispatcher != null) {
            Map<String, Set<IEventListener>> ids2listeners = this.dispatchers2ids2listeners.get(dispatcher);
            Map<IEventListener, Set<String>> listeners2ids = this.dispatchers2listeners2ids.get(dispatcher);
            Set<IEventListener> listeners = ids2listeners.remove(id);
            if (ids2listeners.size() == 0) {
                this.dispatchers2ids2listeners.remove(dispatcher);
                this.dispatchers2listeners2ids.remove(dispatcher);
            }
            for (IEventListener listener : listeners) {
                Set<String> ids = listeners2ids.get(listener);
                ids.remove(id);
                if (ids.size() != 0) continue;
                listeners2ids.remove(listener);
                dispatcher.removeListener(listener);
            }
        }
    }

    public synchronized void registerListener(IEventListener listener, String regexp) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        this.unregisterListener(listener);
        this.listeners2regexps.put(listener, regexp);
        for (Map.Entry<String, IEventDispatcher> entry : this.ids2dispatchers.entrySet()) {
            String id = entry.getKey();
            IEventDispatcher dispatcher = entry.getValue();
            if (!id.matches(regexp)) continue;
            Map<String, Set<IEventListener>> ids2listeners = this.dispatchers2ids2listeners.get(dispatcher);
            Map<IEventListener, Set<String>> listeners2ids = this.dispatchers2listeners2ids.get(dispatcher);
            Set<IEventListener> listeners = ids2listeners.get(id);
            Set<String> ids = listeners2ids.get(listener);
            if (ids == null) {
                ids = new HashSet<String>();
                listeners2ids.put(listener, ids);
                dispatcher.addListener(listener);
            }
            ids.add(id);
            listeners.add(listener);
        }
    }

    public synchronized void unregisterListener(IEventListener listener) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        String regexp = this.listeners2regexps.remove(listener);
        if (regexp != null) {
            for (Map.Entry<String, IEventDispatcher> entry : this.ids2dispatchers.entrySet()) {
                String id = entry.getKey();
                IEventDispatcher dispatcher = entry.getValue();
                if (!id.matches(regexp)) continue;
                Map<String, Set<IEventListener>> ids2listeners = this.dispatchers2ids2listeners.get(dispatcher);
                Map<IEventListener, Set<String>> listeners2ids = this.dispatchers2listeners2ids.get(dispatcher);
                Set<IEventListener> listeners = ids2listeners.get(id);
                Set<String> ids = listeners2ids.get(listener);
                ids.remove(id);
                listeners.remove(listener);
                if (ids.size() != 0) continue;
                listeners2ids.remove(listener);
                dispatcher.removeListener(listener);
            }
        }
    }
}

