/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven.report;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.pitest.aggregate.ReportAggregator;
import org.pitest.functional.FCollection;
import org.pitest.maven.DependencyFilter;
import org.pitest.maven.report.PitReportMojo;
import org.pitest.mutationtest.config.DirectoryResultOutputStrategy;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportDirCreationStrategy;
import org.pitest.mutationtest.config.UndatedReportDirCreationStrategy;
import org.pitest.util.ResultOutputStrategy;

@Mojo(name="report-aggregate-module", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, aggregator=true)
public class PitReportAggregationModuleMojo
extends PitReportMojo {
    private static final String MUTATION_RESULT_FILTER = "target/pit-reports/mutations.xml";
    private static final String LINECOVERAGE_FILTER = "target/pit-reports/linecoverage.xml";
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;

    @Override
    public String getDescription(Locale locale) {
        return this.getName(locale) + " Coverage Report.";
    }

    @Override
    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            List allProjects = this.getProject().getCollectedProjects();
            ReportAggregator.Builder reportAggregationBuilder = ReportAggregator.builder();
            for (MavenProject proj : allProjects) {
                this.addProjectFiles(reportAggregationBuilder, proj);
            }
            ReportAggregator reportAggregator = reportAggregationBuilder.resultOutputStrategy((ResultOutputStrategy)new DirectoryResultOutputStrategy(this.getReportsDirectory().getAbsolutePath(), (ReportDirCreationStrategy)new UndatedReportDirCreationStrategy())).build();
            reportAggregator.aggregateReport();
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    private void addProjectFiles(ReportAggregator.Builder reportAggregationBuilder, MavenProject proj) throws IOException, Exception {
        File projectBaseDir = proj.getBasedir();
        List<File> files = this.getProjectFilesByFilter(projectBaseDir, MUTATION_RESULT_FILTER);
        for (File file : files) {
            reportAggregationBuilder.addMutationResultsFile(file);
        }
        files = this.getProjectFilesByFilter(projectBaseDir, LINECOVERAGE_FILTER);
        for (File file : files) {
            reportAggregationBuilder.addLineCoverageFile(file);
        }
        files = this.convertToRootDirs(proj.getCompileSourceRoots(), proj.getTestCompileSourceRoots());
        for (File file : files) {
            reportAggregationBuilder.addSourceCodeDirectory(file);
        }
        files = this.getCompiledDirs(proj);
        for (File file : files) {
            reportAggregationBuilder.addCompiledCodeDirectory(file);
        }
    }

    private List<File> convertToRootDirs(List ... directoryLists) {
        ArrayList roots = new ArrayList();
        for (List directoryList : directoryLists) {
            roots.addAll(directoryList);
        }
        return FCollection.map(roots, (Function)new Function<String, File>(){

            @Override
            public File apply(String a) {
                return new File(a);
            }
        });
    }

    private List<File> getProjectFilesByFilter(File projectBaseDir, String filter) throws IOException {
        List files = FileUtils.getFiles((File)projectBaseDir, (String)filter, (String)"");
        return files == null ? new ArrayList() : files;
    }

    private List<File> getCompiledDirs(MavenProject project) throws Exception {
        ArrayList<String> sourceRoots = new ArrayList<String>();
        for (Object artifactObj : FCollection.filter(project.getPluginArtifactMap().values(), (Predicate)new DependencyFilter(new PluginServices(PitReportAggregationModuleMojo.class.getClassLoader())))) {
            Artifact artifact = (Artifact)artifactObj;
            sourceRoots.add(artifact.getFile().getAbsolutePath());
        }
        return this.convertToRootDirs(project.getTestClasspathElements(), Arrays.asList(project.getBuild().getOutputDirectory(), project.getBuild().getTestOutputDirectory()), sourceRoots);
    }
}

