/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.easymock.Mock;
import org.powermock.api.easymock.EasyMockConfiguration;
import org.powermock.api.easymock.annotation.MockNice;
import org.powermock.api.easymock.annotation.MockStrict;
import org.powermock.api.extension.listener.EasyMockAnnotationSupport;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.listener.AnnotationEnablerListener;
import org.powermock.core.spi.support.AbstractPowerMockTestListenerBase;
import org.powermock.reflect.Whitebox;

public class AnnotationEnabler
extends AbstractPowerMockTestListenerBase
implements AnnotationEnablerListener {
    public Class<? extends Annotation>[] getMockAnnotations() {
        return new Class[]{org.powermock.api.easymock.annotation.Mock.class, org.powermock.core.classloader.annotations.Mock.class, MockNice.class, MockStrict.class};
    }

    public void beforeTestMethod(Object testInstance, Method method, Object[] arguments) throws Exception {
        EasyMockConfiguration easyMockConfiguration = EasyMockConfiguration.getConfiguration();
        if (!easyMockConfiguration.isReallyEasyMock()) {
            return;
        }
        if (easyMockConfiguration.isInjectMocksSupported()) {
            Whitebox.invokeMethod(Class.forName("org.easymock.EasyMockSupport"), (String)"injectMocks", (Object[])new Object[]{testInstance});
            this.registerAllCreatedMocks(testInstance);
        }
        this.getEasyMockAnnotationSupport(testInstance).injectMocks();
    }

    protected EasyMockAnnotationSupport getEasyMockAnnotationSupport(Object testInstance) {
        return new EasyMockAnnotationSupport(testInstance);
    }

    private void registerAllCreatedMocks(Object testInstance) {
        Field[] fields;
        for (Field field : fields = testInstance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Mock.class)) continue;
            Object value = Whitebox.getFieldValue((Field)field, (Object)testInstance);
            MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{value});
        }
    }
}

