/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.nodes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.nodes.ContextAwareNode;
import org.raml.v2.internal.impl.commons.nodes.ContextAwareStringNodeImpl;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.AbstractStringNode;
import org.raml.yagi.framework.nodes.ExecutableNode;
import org.raml.yagi.framework.nodes.ExecutionContext;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;

public class StringTemplateNode
extends AbstractStringNode
implements ExecutableNode {
    public StringTemplateNode(String value) {
        super(value);
    }

    public StringTemplateNode(StringTemplateNode node) {
        super((AbstractStringNode)node);
    }

    public void addChild(Node node) {
        if (!(node instanceof StringNode)) {
            throw new IllegalArgumentException("Only String nodes are valid as children");
        }
        super.addChild(node);
    }

    public Node execute(ExecutionContext context) {
        List<Node> executedNodes = this.executeNodes(context, this.getChildren());
        return this.resolveTemplate(context, executedNodes);
    }

    private Node resolveTemplate(ExecutionContext context, List<Node> executedNodes) {
        if (executedNodes.size() == 1 && !(executedNodes.get(0) instanceof StringNode)) {
            return executedNodes.get(0);
        }
        StringBuilder content = new StringBuilder();
        Node referenceContext = null;
        for (Node executedNode : executedNodes) {
            if (executedNode instanceof SimpleTypeNode) {
                content.append(((SimpleTypeNode)executedNode).getLiteralValue());
                if (referenceContext != null || !(executedNode instanceof ContextAwareStringNodeImpl)) continue;
                referenceContext = ((ContextAwareNode)executedNode).getReferenceContext();
                continue;
            }
            return ErrorNodeFactory.createInvalidType((Node)executedNode, (NodeType)NodeType.String);
        }
        if (referenceContext == null) {
            referenceContext = context.getContextNode();
        }
        return new ContextAwareStringNodeImpl(content.toString(), referenceContext);
    }

    private List<Node> executeNodes(ExecutionContext context, List<Node> children) {
        ArrayList<Node> executedNodes = new ArrayList<Node>();
        for (Node child : children) {
            if (child instanceof ExecutableNode) {
                executedNodes.add(((ExecutableNode)child).execute(context));
                continue;
            }
            executedNodes.add(child);
        }
        return executedNodes;
    }

    @Nonnull
    public Node copy() {
        return new StringTemplateNode(this);
    }

    public void replaceWith(Node newNode) {
        if (this != newNode) {
            this.replaceTree(newNode);
        }
    }
}

