/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.DelegatingMethodParameter;
import org.springdoc.core.GenericParameterService;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationService;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.RequestBodyService;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpMethod;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractRequestService {
    private static final List<Class<?>> PARAM_TYPES_TO_IGNORE = new ArrayList();
    private static final String[] ANNOTATIONS_FOR_REQUIRED = new String[]{"NotNull", "NonNull", "NotBlank", "NotEmpty"};
    private static final String POSITIVE_OR_ZERO = "PositiveOrZero";
    private static final String NEGATIVE_OR_ZERO = "NegativeOrZero";
    private final GenericParameterService parameterBuilder;
    private final RequestBodyService requestBodyService;
    private final OperationService operationService;
    private final LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer;
    private final Optional<List<ParameterCustomizer>> parameterCustomizers;

    protected AbstractRequestService(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, OperationService operationService, Optional<List<ParameterCustomizer>> parameterCustomizers, LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyService = requestBodyService;
        this.operationService = operationService;
        parameterCustomizers.ifPresent(customizers -> customizers.removeIf(Objects::isNull));
        this.parameterCustomizers = parameterCustomizers;
        this.localSpringDocParameterNameDiscoverer = localSpringDocParameterNameDiscoverer;
    }

    public static void addRequestWrapperToIgnore(Class<?> ... classes) {
        PARAM_TYPES_TO_IGNORE.addAll(Arrays.asList(classes));
    }

    public static void removeRequestWrapperToIgnore(Class<?> ... classes) {
        List<Class<?>> classesToIgnore = Arrays.asList(classes);
        if (PARAM_TYPES_TO_IGNORE.containsAll(classesToIgnore)) {
            PARAM_TYPES_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    public static boolean isRequestTypeToIgnore(Class<?> rawClass) {
        return PARAM_TYPES_TO_IGNORE.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public Operation build(HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, MethodAttributes methodAttributes, OpenAPI openAPI) {
        String operationId = this.operationService.getOperationId(handlerMethod.getMethod().getName(), operation.getOperationId(), openAPI);
        operation.setOperationId(operationId);
        String[] pNames = this.localSpringDocParameterNameDiscoverer.getParameterNames(handlerMethod.getMethod());
        MethodParameter[] parameters = handlerMethod.getMethodParameters();
        String[] reflectionParametersNames = (String[])Arrays.stream(handlerMethod.getMethod().getParameters()).map(Parameter::getName).toArray(String[]::new);
        if (pNames == null || Arrays.stream(pNames).anyMatch(Objects::isNull)) {
            pNames = reflectionParametersNames;
        }
        parameters = DelegatingMethodParameter.customize(pNames, parameters, this.parameterBuilder.getDelegatingMethodParameterCustomizer());
        RequestBodyInfo requestBodyInfo = new RequestBodyInfo();
        List operationParameters = operation.getParameters() != null ? operation.getParameters() : new ArrayList();
        Map<String, io.swagger.v3.oas.annotations.Parameter> parametersDocMap = this.getApiParameters(handlerMethod.getMethod());
        Components components = openAPI.getComponents();
        for (MethodParameter methodParameter : parameters) {
            io.swagger.v3.oas.models.parameters.Parameter parameter;
            io.swagger.v3.oas.annotations.Parameter parameterDoc = (io.swagger.v3.oas.annotations.Parameter)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])methodParameter.getParameterAnnotations()), io.swagger.v3.oas.annotations.Parameter.class);
            String pName = methodParameter.getParameterName();
            ParameterInfo parameterInfo = new ParameterInfo(pName, methodParameter, this.parameterBuilder);
            if (parameterDoc == null) {
                parameterDoc = parametersDocMap.get(parameterInfo.getpName());
            }
            if (parameterDoc != null) {
                if (parameterDoc.hidden() || parameterDoc.schema().hidden()) continue;
                parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, components, methodAttributes.getJsonViewAnnotation());
                parameterInfo.setParameterModel(parameter);
            }
            if (this.isParamToIgnore(methodParameter)) continue;
            parameter = this.buildParams(parameterInfo, parameters.length, components, requestMethod, methodAttributes.getJsonViewAnnotation());
            parameter = GenericParameterService.mergeParameter(operationParameters, parameter);
            List<Annotation> parameterAnnotations = Arrays.asList(methodParameter.getParameterAnnotations());
            if (this.isValidParameter(parameter)) {
                this.applyBeanValidatorAnnotations(parameter, parameterAnnotations);
            } else if (!RequestMethod.GET.equals((Object)requestMethod)) {
                if (operation.getRequestBody() != null) {
                    requestBodyInfo.setRequestBody(operation.getRequestBody());
                }
                this.requestBodyService.calculateRequestBodyInfo(components, methodAttributes, parameterInfo, requestBodyInfo);
                this.applyBeanValidatorAnnotations(requestBodyInfo.getRequestBody(), parameterAnnotations, methodParameter.isOptional());
            }
            this.customiseParameter(parameter, parameterInfo);
        }
        LinkedHashMap<String, io.swagger.v3.oas.models.parameters.Parameter> map = this.getParameterLinkedHashMap(components, methodAttributes, operationParameters, parametersDocMap);
        this.setParams(operation, new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(map.values()), requestBodyInfo);
        return operation;
    }

    private LinkedHashMap<String, io.swagger.v3.oas.models.parameters.Parameter> getParameterLinkedHashMap(Components components, MethodAttributes methodAttributes, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, Map<String, io.swagger.v3.oas.annotations.Parameter> parametersDocMap) {
        LinkedHashMap map = operationParameters.stream().collect(Collectors.toMap(parameter -> parameter.getName() != null ? parameter.getName() : Integer.toString(parameter.hashCode()), parameter -> parameter, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        for (Map.Entry<String, io.swagger.v3.oas.annotations.Parameter> entry : parametersDocMap.entrySet()) {
            if (entry.getKey() == null || map.containsKey(entry.getKey()) || entry.getValue().hidden()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter2 = this.parameterBuilder.buildParameterFromDoc(entry.getValue(), components, methodAttributes.getJsonViewAnnotation());
            map.put(entry.getKey(), parameter2);
        }
        AbstractRequestService.getHeaders(methodAttributes, map);
        return map;
    }

    public static Collection<io.swagger.v3.oas.models.parameters.Parameter> getHeaders(MethodAttributes methodAttributes, Map<String, io.swagger.v3.oas.models.parameters.Parameter> map) {
        for (Map.Entry<String, String> entry : methodAttributes.getHeaders().entrySet()) {
            StringSchema schema = new StringSchema();
            if (StringUtils.isNotEmpty((CharSequence)entry.getValue())) {
                schema.addEnumItem(entry.getValue());
            }
            io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter().in(ParameterIn.HEADER.toString()).name(entry.getKey()).schema((Schema)schema);
            if (map.containsKey(entry.getKey())) {
                parameter = map.get(entry.getKey());
                if (StringUtils.isNotEmpty((CharSequence)entry.getValue())) {
                    parameter.getSchema().addEnumItemObject((Object)entry.getValue());
                }
                parameter.setSchema(parameter.getSchema());
            }
            map.put(entry.getKey(), parameter);
        }
        return map.values();
    }

    protected io.swagger.v3.oas.models.parameters.Parameter customiseParameter(io.swagger.v3.oas.models.parameters.Parameter parameter, ParameterInfo parameterInfo) {
        this.parameterCustomizers.ifPresent(customizers -> customizers.forEach(customizer -> customizer.customize(parameter, parameterInfo.getMethodParameter())));
        return parameter;
    }

    public boolean isParamToIgnore(MethodParameter parameter) {
        if (SpringDocAnnotationsUtils.isAnnotationToIgnore(parameter)) {
            return true;
        }
        if (this.isRequiredAnnotation(parameter)) {
            return false;
        }
        return AbstractRequestService.isRequestTypeToIgnore(parameter.getParameterType());
    }

    private boolean isRequiredAnnotation(MethodParameter parameter) {
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        PathVariable pathVariable = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        org.springframework.web.bind.annotation.RequestBody requestBody = (org.springframework.web.bind.annotation.RequestBody)parameter.getParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class);
        return requestParam != null && requestParam.required() || pathVariable != null && pathVariable.required() || requestBody != null && requestBody.required();
    }

    private void setParams(Operation operation, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, RequestBodyInfo requestBodyInfo) {
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        if (requestBodyInfo.getRequestBody() != null) {
            operation.setRequestBody(requestBodyInfo.getRequestBody());
        }
    }

    public boolean isValidParameter(io.swagger.v3.oas.models.parameters.Parameter parameter) {
        return parameter != null && (parameter.getName() != null || parameter.get$ref() != null);
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParams(ParameterInfo parameterInfo, int length, Components components, RequestMethod requestMethod, JsonView jsonView) {
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        if (parameterInfo.getParamType() != null) {
            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(parameterInfo.getDefaultValue())) {
                parameterInfo.setRequired(false);
            } else {
                parameterInfo.setDefaultValue(null);
            }
            return this.buildParam(parameterInfo, components, jsonView);
        }
        if (!this.isRequestBodyParam(requestMethod, parameterInfo, length)) {
            parameterInfo.setRequired(!((DelegatingMethodParameter)methodParameter).isNotRequired() && !methodParameter.isOptional());
            parameterInfo.setParamType("query");
            parameterInfo.setDefaultValue(null);
            return this.buildParam(parameterInfo, components, jsonView);
        }
        return null;
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParam(ParameterInfo parameterInfo, Components components, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = parameterInfo.getParameterModel();
        String name = parameterInfo.getpName();
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameterInfo.setParameterModel(parameter);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getName())) {
            parameter.setName(name);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getIn())) {
            parameter.setIn(parameterInfo.getParamType());
        }
        if (parameter.getRequired() == null) {
            parameter.setRequired(Boolean.valueOf(parameterInfo.isRequired()));
        }
        if (SchemaPropertyDeprecatingConverter.containsDeprecatedAnnotation(parameterInfo.getMethodParameter().getParameterAnnotations())) {
            parameter.setDeprecated(Boolean.valueOf(true));
        }
        if (parameter.getSchema() == null && parameter.getContent() == null) {
            Schema schema = this.parameterBuilder.calculateSchema(components, parameterInfo, null, jsonView);
            if (parameterInfo.getDefaultValue() != null && schema != null) {
                Object defaultValue = parameterInfo.getDefaultValue();
                PrimitiveType primitiveType = PrimitiveType.fromTypeAndFormat((String)schema.getType(), (String)schema.getFormat());
                if (primitiveType != null) {
                    Schema primitiveSchema = primitiveType.createProperty();
                    primitiveSchema.setDefault(parameterInfo.getDefaultValue());
                    defaultValue = primitiveSchema.getDefault();
                }
                schema.setDefault(defaultValue);
            }
            parameter.setSchema(schema);
        }
        return parameter;
    }

    public void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getSimpleName(), (Annotation)annotation));
        }
        boolean annotationExists = Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annos::containsKey);
        if (annotationExists) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        this.applyValidationsToSchema(annos, schema);
    }

    public void applyBeanValidatorAnnotations(RequestBody requestBody, List<Annotation> annotations, boolean isOptional) {
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        boolean requestBodyRequired = false;
        if (!CollectionUtils.isEmpty(annotations)) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getSimpleName(), (Annotation)annotation));
            requestBodyRequired = annotations.stream().filter(annotation -> org.springframework.web.bind.annotation.RequestBody.class.equals(annotation.annotationType())).anyMatch(annotation -> ((org.springframework.web.bind.annotation.RequestBody)annotation).required());
        }
        boolean validationExists = Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annos::containsKey);
        if (validationExists || !isOptional && requestBodyRequired) {
            requestBody.setRequired(Boolean.valueOf(true));
        }
        Content content = requestBody.getContent();
        for (MediaType mediaType : content.values()) {
            Schema schema = mediaType.getSchema();
            this.applyValidationsToSchema(annos, schema);
        }
    }

    private void calculateSize(Map<String, Annotation> annos, Schema<?> schema) {
        if (annos.containsKey(Size.class.getSimpleName())) {
            Size size = (Size)annos.get(Size.class.getSimpleName());
            if ("array".equals(schema.getType())) {
                schema.setMinItems(Integer.valueOf(size.min()));
                schema.setMaxItems(Integer.valueOf(size.max()));
            } else if ("string".equals(schema.getType())) {
                schema.setMinLength(Integer.valueOf(size.min()));
                schema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
    }

    public RequestBodyService getRequestBodyBuilder() {
        return this.requestBodyService;
    }

    private Map<String, io.swagger.v3.oas.annotations.Parameter> getApiParameters(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set apiParametersDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Parameters.class);
        LinkedHashMap apiParametersMap = apiParametersDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        Set apiParametersDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, Parameters.class);
        LinkedHashMap apiParametersDocDeclaringClassMap = apiParametersDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParametersDocDeclaringClassMap);
        Set apiParameterDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocMap = apiParameterDoc.stream().collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocMap);
        Set apiParameterDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocDeclaringClassMap = apiParameterDocDeclaringClass.stream().collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocDeclaringClassMap);
        return apiParametersMap;
    }

    private void applyValidationsToSchema(Map<String, Annotation> annos, Schema<?> schema) {
        Max max;
        Min min;
        if (annos.containsKey(Min.class.getSimpleName())) {
            min = (Min)annos.get(Min.class.getSimpleName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getSimpleName())) {
            max = (Max)annos.get(Max.class.getSimpleName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        this.calculateSize(annos, schema);
        if (annos.containsKey(DecimalMin.class.getSimpleName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getSimpleName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.parseDouble(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(true));
            }
        }
        if (annos.containsKey(DecimalMax.class.getSimpleName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getSimpleName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.parseDouble(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(true));
            }
        }
        if (annos.containsKey(POSITIVE_OR_ZERO)) {
            schema.setMinimum(BigDecimal.ZERO);
        }
        if (annos.containsKey(NEGATIVE_OR_ZERO)) {
            schema.setMaximum(BigDecimal.ZERO);
        }
        if (annos.containsKey(Pattern.class.getSimpleName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getSimpleName());
            schema.setPattern(pattern.regexp());
        }
    }

    private boolean isRequestBodyParam(RequestMethod requestMethod, ParameterInfo parameterInfo, int length) {
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        DelegatingMethodParameter delegatingMethodParameter = (DelegatingMethodParameter)methodParameter;
        return !(RequestMethod.GET.equals((Object)requestMethod) || parameterInfo.getParameterModel() != null && parameterInfo.getParameterModel().getIn() != null || delegatingMethodParameter.isParameterObject() || methodParameter.getParameterAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class) == null && methodParameter.getParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class) == null && methodParameter.getParameterAnnotation(RequestPart.class) == null && (ClassUtils.isPrimitiveOrWrapper(methodParameter.getParameter().getType()) || ArrayUtils.isEmpty((Object[])methodParameter.getParameterAnnotations()) && length != 1));
    }

    static {
        PARAM_TYPES_TO_IGNORE.add(WebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(NativeWebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(Principal.class);
        PARAM_TYPES_TO_IGNORE.add(HttpMethod.class);
        PARAM_TYPES_TO_IGNORE.add(Locale.class);
        PARAM_TYPES_TO_IGNORE.add(TimeZone.class);
        PARAM_TYPES_TO_IGNORE.add(InputStream.class);
        PARAM_TYPES_TO_IGNORE.add(ZoneId.class);
        PARAM_TYPES_TO_IGNORE.add(Reader.class);
        PARAM_TYPES_TO_IGNORE.add(OutputStream.class);
        PARAM_TYPES_TO_IGNORE.add(Writer.class);
        PARAM_TYPES_TO_IGNORE.add(Map.class);
        PARAM_TYPES_TO_IGNORE.add(Model.class);
        PARAM_TYPES_TO_IGNORE.add(ModelMap.class);
        PARAM_TYPES_TO_IGNORE.add(Errors.class);
        PARAM_TYPES_TO_IGNORE.add(BindingResult.class);
        PARAM_TYPES_TO_IGNORE.add(SessionStatus.class);
        PARAM_TYPES_TO_IGNORE.add(UriComponentsBuilder.class);
        PARAM_TYPES_TO_IGNORE.add(RequestAttribute.class);
    }
}

