/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class ExpressionEvaluatingParameterBinder {
    private final SpelExpressionParser expressionParser;
    private final EvaluationContextProvider evaluationContextProvider;

    public ExpressionEvaluatingParameterBinder(SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public String bind(String raw, MongoParameterAccessor accessor, BindingContext bindingContext) {
        if (!StringUtils.hasText((String)raw)) {
            return null;
        }
        return this.replacePlaceholders(raw, accessor, bindingContext);
    }

    private String replacePlaceholders(String input, MongoParameterAccessor accessor, BindingContext bindingContext) {
        if (!bindingContext.hasBindings()) {
            return input;
        }
        if (input.matches("^\\?\\d+$")) {
            return this.getParameterValueForBinding(accessor, bindingContext.getParameters(), bindingContext.getBindings().iterator().next());
        }
        Matcher matcher = this.createReplacementPattern(bindingContext.getBindings()).matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            StringBasedMongoQuery.ParameterBinding binding = bindingContext.getBindingFor(this.extractPlaceholder(matcher.group()));
            String valueForBinding = this.getParameterValueForBinding(accessor, bindingContext.getParameters(), binding);
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(valueForBinding));
            if (!binding.isQuoted()) continue;
            this.postProcessQuotedBinding(buffer, valueForBinding);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private void postProcessQuotedBinding(StringBuffer buffer, String valueForBinding) {
        int quotationMarkIndex = buffer.length() - valueForBinding.length() - 1;
        char quotationMark = buffer.charAt(quotationMarkIndex);
        while (quotationMark != '\'' && quotationMark != '\"') {
            if (--quotationMarkIndex < 0) {
                throw new IllegalArgumentException("Could not find opening quotes for quoted parameter");
            }
            quotationMark = buffer.charAt(quotationMarkIndex);
        }
        if (valueForBinding.startsWith("{")) {
            buffer.deleteCharAt(quotationMarkIndex);
        } else {
            if (quotationMark == '\'') {
                buffer.replace(quotationMarkIndex, quotationMarkIndex + 1, "\"");
            }
            buffer.append("\"");
        }
    }

    private String getParameterValueForBinding(MongoParameterAccessor accessor, MongoParameters parameters, StringBasedMongoQuery.ParameterBinding binding) {
        Object value;
        Object object = value = binding.isExpression() ? this.evaluateExpression(binding.getExpression(), parameters, accessor.getValues()) : accessor.getBindableValue(binding.getParameterIndex());
        if (value instanceof String && binding.isQuoted()) {
            return ((String)value).startsWith("{") ? (String)value : ((String)value).replace("\"", "\\\"");
        }
        if (value instanceof byte[]) {
            String base64representation = DatatypeConverter.printBase64Binary((byte[])((byte[])value));
            if (!binding.isQuoted()) {
                return "{ '$binary' : '" + base64representation + "', '$type' : " + 0 + "}";
            }
            return base64representation;
        }
        return JSON.serialize((Object)value);
    }

    private Object evaluateExpression(String expressionString, MongoParameters parameters, Object[] parameterValues) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Parameters)parameters, parameterValues);
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(evaluationContext, Object.class);
    }

    private Pattern createReplacementPattern(List<StringBasedMongoQuery.ParameterBinding> bindings) {
        StringBuilder regex = new StringBuilder();
        for (StringBasedMongoQuery.ParameterBinding binding : bindings) {
            regex.append("|");
            regex.append(Pattern.quote(binding.getParameter()));
            regex.append("['\"]?");
        }
        return Pattern.compile(regex.substring(1));
    }

    private Placeholder extractPlaceholder(String groupName) {
        return !groupName.endsWith("'") && !groupName.endsWith("\"") ? Placeholder.of(groupName, false) : Placeholder.of(groupName.substring(0, groupName.length() - 1), true);
    }

    static final class Placeholder {
        private final String parameter;
        private final boolean quoted;

        public String toString() {
            return this.quoted ? String.format("'%s'", this.parameter) : this.parameter;
        }

        private Placeholder(String parameter, boolean quoted) {
            this.parameter = parameter;
            this.quoted = quoted;
        }

        public static Placeholder of(String parameter, boolean quoted) {
            return new Placeholder(parameter, quoted);
        }

        public String getParameter() {
            return this.parameter;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Placeholder)) {
                return false;
            }
            Placeholder other = (Placeholder)o;
            String this$parameter = this.getParameter();
            String other$parameter = other.getParameter();
            if (this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter)) {
                return false;
            }
            return this.isQuoted() == other.isQuoted();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $parameter = this.getParameter();
            result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
            result = result * 59 + (this.isQuoted() ? 79 : 97);
            return result;
        }
    }

    static class BindingContext {
        final MongoParameters parameters;
        final Map<Placeholder, StringBasedMongoQuery.ParameterBinding> bindings;

        public BindingContext(MongoParameters parameters, List<StringBasedMongoQuery.ParameterBinding> bindings) {
            this.parameters = parameters;
            this.bindings = BindingContext.mapBindings(bindings);
        }

        boolean hasBindings() {
            return !CollectionUtils.isEmpty(this.bindings);
        }

        public List<StringBasedMongoQuery.ParameterBinding> getBindings() {
            return new ArrayList<StringBasedMongoQuery.ParameterBinding>(this.bindings.values());
        }

        StringBasedMongoQuery.ParameterBinding getBindingFor(Placeholder placeholder) {
            if (!this.bindings.containsKey(placeholder)) {
                throw new NoSuchElementException(String.format("Could not to find binding for placeholder '%s'.", placeholder));
            }
            return this.bindings.get(placeholder);
        }

        public MongoParameters getParameters() {
            return this.parameters;
        }

        private static Map<Placeholder, StringBasedMongoQuery.ParameterBinding> mapBindings(List<StringBasedMongoQuery.ParameterBinding> bindings) {
            LinkedHashMap<Placeholder, StringBasedMongoQuery.ParameterBinding> map = new LinkedHashMap<Placeholder, StringBasedMongoQuery.ParameterBinding>(bindings.size(), 1.0f);
            for (StringBasedMongoQuery.ParameterBinding binding : bindings) {
                map.put(Placeholder.of(binding.getParameter(), binding.isQuoted()), binding);
            }
            return map;
        }
    }
}

