/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.lang.Nullable;

public class PrefixingDelegatingAggregationOperationContext
implements AggregationOperationContext {
    private final AggregationOperationContext delegate;
    private final String prefix;
    private final Set<String> denylist;

    public PrefixingDelegatingAggregationOperationContext(AggregationOperationContext delegate, String prefix) {
        this(delegate, prefix, Collections.emptySet());
    }

    public PrefixingDelegatingAggregationOperationContext(AggregationOperationContext delegate, String prefix, Collection<String> denylist) {
        this.delegate = delegate;
        this.prefix = prefix;
        this.denylist = new HashSet<String>(denylist);
    }

    @Override
    public Document getMappedObject(Document document) {
        return this.doPrefix(this.delegate.getMappedObject(document));
    }

    @Override
    public Document getMappedObject(Document document, @Nullable Class<?> type) {
        return this.doPrefix(this.delegate.getMappedObject(document, type));
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        return this.delegate.getReference(field);
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.delegate.getReference(name);
    }

    @Override
    public Fields getFields(Class<?> type) {
        return this.delegate.getFields(type);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    private Document doPrefix(Document source) {
        Document result = new Document();
        for (Map.Entry entry : source.entrySet()) {
            String key = this.prefixKey((String)entry.getKey());
            Object value = entry.getValue();
            if (entry.getValue() instanceof Collection) {
                Collection sourceCollection = (Collection)entry.getValue();
                value = this.prefixCollection(sourceCollection);
            }
            result.append(key, value);
        }
        return result;
    }

    private String prefixKey(String key) {
        return key.startsWith("$") || this.isDenied(key) ? key : this.prefix + "." + key;
    }

    private Object prefixCollection(Collection<Object> sourceCollection) {
        ArrayList<Object> prefixed = new ArrayList<Object>(sourceCollection.size());
        for (Object o : sourceCollection) {
            if (o instanceof Document) {
                prefixed.add(this.doPrefix((Document)o));
                continue;
            }
            prefixed.add(o);
        }
        return prefixed;
    }

    private boolean isDenied(String key) {
        if (this.denylist.contains(key)) {
            return true;
        }
        if (!key.contains(".")) {
            return false;
        }
        for (String denied : this.denylist) {
            if (!key.startsWith(denied + ".")) continue;
            return true;
        }
        return false;
    }
}

