/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.messaging.Cancelable;
import org.springframework.data.mongodb.core.messaging.MessageListenerContainer;
import org.springframework.data.mongodb.core.messaging.Subscription;
import org.springframework.data.mongodb.core.messaging.SubscriptionRequest;
import org.springframework.data.mongodb.core.messaging.Task;
import org.springframework.data.mongodb.core.messaging.TaskFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.ObjectUtils;

public class DefaultMessageListenerContainer
implements MessageListenerContainer {
    private final Executor taskExecutor;
    private final TaskFactory taskFactory;
    private final Optional<ErrorHandler> errorHandler;
    private final Object lifecycleMonitor = new Object();
    private final Map<SubscriptionRequest, Subscription> subscriptions = new LinkedHashMap<SubscriptionRequest, Subscription>();
    private boolean running = false;

    public DefaultMessageListenerContainer(MongoTemplate template) {
        this(template, (Executor)new SimpleAsyncTaskExecutor());
    }

    public DefaultMessageListenerContainer(MongoTemplate template, Executor taskExecutor) {
        this(template, taskExecutor, null);
    }

    public DefaultMessageListenerContainer(MongoTemplate template, Executor taskExecutor, @Nullable ErrorHandler errorHandler) {
        Assert.notNull((Object)template, (String)"Template must not be null");
        Assert.notNull((Object)taskExecutor, (String)"TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
        this.taskFactory = new TaskFactory(template);
        this.errorHandler = Optional.ofNullable(errorHandler);
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                return;
            }
            this.subscriptions.values().stream().filter(it -> !it.isActive()).filter(it -> it instanceof TaskSubscription).map(TaskSubscription.class::cast).map(TaskSubscription::getTask).forEach(this.taskExecutor::execute);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                this.subscriptions.values().forEach(Cancelable::cancel);
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    @Override
    public <S, T> Subscription register(SubscriptionRequest<S, ? super T, ? extends SubscriptionRequest.RequestOptions> request, Class<T> bodyType) {
        return this.register(request, bodyType, this.errorHandler.orElseGet(() -> new DecoratingLoggingErrorHandler(exception -> this.lookup(request).ifPresent(Cancelable::cancel))));
    }

    @Override
    public <S, T> Subscription register(SubscriptionRequest<S, ? super T, ? extends SubscriptionRequest.RequestOptions> request, Class<T> bodyType, ErrorHandler errorHandler) {
        return this.register(request, this.taskFactory.forRequest(request, bodyType, errorHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Subscription> lookup(SubscriptionRequest<?, ?, ?> request) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return Optional.ofNullable(this.subscriptions.get(request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription register(SubscriptionRequest request, Task task) {
        TaskSubscription subscription = new TaskSubscription(task);
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.subscriptions.containsKey(request)) {
                return this.subscriptions.get(request);
            }
            this.subscriptions.put(request, subscription);
            if (this.running) {
                this.taskExecutor.execute((Runnable)((Object)task));
            }
        }
        return subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Subscription subscription) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.subscriptions.containsValue(subscription)) {
                if (subscription.isActive()) {
                    subscription.cancel();
                }
                this.subscriptions.values().remove(subscription);
            }
        }
    }

    static class TaskSubscription
    implements Subscription {
        private final Task task;

        TaskSubscription(Task task) {
            this.task = task;
        }

        Task getTask() {
            return this.task;
        }

        @Override
        public boolean isActive() {
            return this.task.isActive();
        }

        @Override
        public boolean await(Duration timeout) throws InterruptedException {
            return this.task.awaitStart(timeout);
        }

        @Override
        public void cancel() throws DataAccessResourceFailureException {
            this.task.cancel();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskSubscription that = (TaskSubscription)o;
            return ObjectUtils.nullSafeEquals((Object)this.task, (Object)that.task);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.task);
        }
    }

    private static class DecoratingLoggingErrorHandler
    implements ErrorHandler {
        private final Log logger = LogFactory.getLog(DecoratingLoggingErrorHandler.class);
        private final ErrorHandler delegate;

        DecoratingLoggingErrorHandler(ErrorHandler delegate) {
            this.delegate = delegate;
        }

        public void handleError(Throwable t) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Unexpected error occurred while listening to MongoDB", t);
            }
            this.delegate.handleError(t);
        }
    }
}

