/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class TermFrequencyFunction
extends AbstractFunction {
    private static final String OPERATION = "termfreq";

    private TermFrequencyFunction(Field field, String term) {
        super(Arrays.asList(field, term));
    }

    public static Builder termFequency(String term) {
        return new Builder(term);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private final String term;

        public Builder(String term) {
            this.term = term;
        }

        public TermFrequencyFunction inField(String fieldName) {
            Assert.hasText((String)fieldName, (String)"fieldName for termfrequency must not be 'empty'.");
            return this.inField(new SimpleField(fieldName));
        }

        public TermFrequencyFunction inField(Field field) {
            Assert.notNull((Object)field, (String)"Field for termfrequency must not be 'null'.");
            return new TermFrequencyFunction(field, this.term);
        }
    }
}

