/**
 * <h1>AWS Systems Manager Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Install the module:
 * <p>
 * <blockquote><pre>
 * $ npm i &#64;aws-cdk/aws-ssm
 * </pre></blockquote>
 * <p>
 * Import it into your code:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.ssm.*;
 * </pre></blockquote>
 * <p>
 * <h2>Using existing SSM Parameters in your CDK app</h2>
 * <p>
 * You can reference existing SSM Parameter Store values that you want to use in
 * your CDK app by using <code>ssm.ParameterStoreString</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // Retrieve the latest value of the non-secret parameter
 * // with name "/My/String/Parameter".
 * String stringValue = ssm.StringParameter.fromStringParameterAttributes(this, 'MyValue', {
 *       parameterName: '/My/Public/Parameter',
 *       // 'version' can be specified but is optional.
 *     }).getStringValue();
 * 
 * // Retrieve a specific version of the secret (SecureString) parameter.
 * // 'version' is always required.
 * IStringParameter secretValue = ssm.StringParameter.fromSecureStringParameterAttributes(this, "MySecureValue", new SecureStringParameterAttributes()
 *         .parameterName("/My/Secret/Parameter")
 *         .version(5));
 * </pre></blockquote>
 * <p>
 * <h2>Creating new SSM Parameters in your CDK app</h2>
 * <p>
 * You can create either <code>ssm.StringParameter</code> or <code>ssm.StringListParameter</code>s in
 * a CDK app. These are public (not secret) values. Parameters of type
 * <em>SecretString</em> cannot be created directly from a CDK application; if you want
 * to provision secrets automatically, use Secrets Manager Secrets (see the
 * <code>&#64;aws-cdk/aws-secretsmanager</code> package).
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * StringParameter.Builder.create(stack, "Parameter")
 *         .allowedPattern(".*")
 *         .description("The value Foo")
 *         .parameterName("FooParameter")
 *         .stringValue("Foo")
 *         .tier(ssm.ParameterTier.getADVANCED())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // Create a new SSM Parameter holding a String
 * StringParameter param = new StringParameter(stack, "StringParameter", new StringParameterProps()
 *         // description: 'Some user-friendly description',
 *         // name: 'ParameterName',
 *         .stringValue("Initial parameter value"));
 * 
 * // Grant read access to some Role
 * param.grantRead(role);
 * 
 * // Create a new SSM Parameter holding a StringList
 * StringListParameter listParameter = new StringListParameter(stack, "StringListParameter", new StringListParameterProps()
 *         // description: 'Some user-friendly description',
 *         // name: 'ParameterName',
 *         .stringListValue(asList("Initial parameter value A", "Initial parameter value B")));
 * </pre></blockquote>
 * <p>
 * When specifying an <code>allowedPattern</code>, the values provided as string literals
 * are validated against the pattern and an exception is raised if a value
 * provided does not comply.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.ssm;
