/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pinpoint.model.BadRequestException;
import software.amazon.awssdk.services.pinpoint.model.CreateAppRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateAppResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.ForbiddenException;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.InternalServerErrorException;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysRequest;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesResponse;
import software.amazon.awssdk.services.pinpoint.model.MethodNotAllowedException;
import software.amazon.awssdk.services.pinpoint.model.NotFoundException;
import software.amazon.awssdk.services.pinpoint.model.PayloadTooLargeException;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateRequest;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateResponse;
import software.amazon.awssdk.services.pinpoint.model.PinpointException;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventsResponse;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesRequest;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeletePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignActivitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetChannelsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionActivityMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetPushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListJourneysRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PhoneNumberValidateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.RemoveAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendUsersMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointsBatchRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyStateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateTemplateActiveVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link PinpointAsyncClient}.
 *
 * @see PinpointAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPinpointAsyncClient implements PinpointAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPinpointAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>().withOperationName("CreateApp")
                            .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAppRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createAppRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     * </p>
     *
     * @param createCampaignRequest
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                            .withOperationName("CreateCampaign")
                            .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCampaignRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCampaignRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param createEmailTemplateRequest
     * @return A Java Future containing the result of the CreateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(
            CreateEmailTemplateRequest createEmailTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEmailTemplateRequest, CreateEmailTemplateResponse>()
                            .withOperationName("CreateEmailTemplate")
                            .withMarshaller(new CreateEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEmailTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createEmailTemplateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an export job for an application.
     * </p>
     *
     * @param createExportJobRequest
     * @return A Java Future containing the result of the CreateExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateExportJobResponse> createExportJob(CreateExportJobRequest createExportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateExportJobRequest, CreateExportJobResponse>()
                            .withOperationName("CreateExportJob")
                            .withMarshaller(new CreateExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createExportJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createExportJobRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an import job for an application.
     * </p>
     *
     * @param createImportJobRequest
     * @return A Java Future containing the result of the CreateImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImportJobResponse> createImportJob(CreateImportJobRequest createImportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImportJobRequest, CreateImportJobResponse>()
                            .withOperationName("CreateImportJob")
                            .withMarshaller(new CreateImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createImportJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createImportJobRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a journey for an application.
     * </p>
     *
     * @param createJourneyRequest
     * @return A Java Future containing the result of the CreateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateJourney
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateJourneyResponse> createJourney(CreateJourneyRequest createJourneyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateJourneyRequest, CreateJourneyResponse>()
                            .withOperationName("CreateJourney")
                            .withMarshaller(new CreateJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createJourneyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createJourneyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param createPushTemplateRequest
     * @return A Java Future containing the result of the CreatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreatePushTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePushTemplateResponse> createPushTemplate(CreatePushTemplateRequest createPushTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePushTemplateRequest, CreatePushTemplateResponse>()
                            .withOperationName("CreatePushTemplate")
                            .withMarshaller(new CreatePushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPushTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPushTemplateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreatePushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param createRecommenderConfigurationRequest
     * @return A Java Future containing the result of the CreateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateRecommenderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRecommenderConfigurationResponse> createRecommenderConfiguration(
            CreateRecommenderConfigurationRequest createRecommenderConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRecommenderConfigurationRequest, CreateRecommenderConfigurationResponse>()
                            .withOperationName("CreateRecommenderConfiguration")
                            .withMarshaller(new CreateRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createRecommenderConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRecommenderConfigurationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param createSegmentRequest
     * @return A Java Future containing the result of the CreateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSegmentResponse> createSegment(CreateSegmentRequest createSegmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSegmentRequest, CreateSegmentResponse>()
                            .withOperationName("CreateSegment")
                            .withMarshaller(new CreateSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSegmentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSegmentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param createSmsTemplateRequest
     * @return A Java Future containing the result of the CreateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSmsTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSmsTemplateResponse> createSmsTemplate(CreateSmsTemplateRequest createSmsTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSmsTemplateRequest, CreateSmsTemplateResponse>()
                            .withOperationName("CreateSmsTemplate")
                            .withMarshaller(new CreateSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSmsTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSmsTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param createVoiceTemplateRequest
     * @return A Java Future containing the result of the CreateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateVoiceTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVoiceTemplateResponse> createVoiceTemplate(
            CreateVoiceTemplateRequest createVoiceTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVoiceTemplateRequest, CreateVoiceTemplateResponse>()
                            .withOperationName("CreateVoiceTemplate")
                            .withMarshaller(new CreateVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVoiceTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createVoiceTemplateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteAdmChannelRequest
     * @return A Java Future containing the result of the DeleteAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAdmChannelResponse> deleteAdmChannel(DeleteAdmChannelRequest deleteAdmChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAdmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAdmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAdmChannelRequest, DeleteAdmChannelResponse>()
                            .withOperationName("DeleteAdmChannel")
                            .withMarshaller(new DeleteAdmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAdmChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAdmChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteAdmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsChannelRequest
     * @return A Java Future containing the result of the DeleteApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsChannelResponse> deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsChannelRequest, DeleteApnsChannelResponse>()
                            .withOperationName("DeleteApnsChannel")
                            .withMarshaller(new DeleteApnsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteApnsChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteApnsChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteApnsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsSandboxChannelRequest
     * @return A Java Future containing the result of the DeleteApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsSandboxChannelResponse> deleteApnsSandboxChannel(
            DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsSandboxChannelRequest, DeleteApnsSandboxChannelResponse>()
                            .withOperationName("DeleteApnsSandboxChannel")
                            .withMarshaller(new DeleteApnsSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteApnsSandboxChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteApnsSandboxChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteApnsSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipChannelRequest
     * @return A Java Future containing the result of the DeleteApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsVoipChannelResponse> deleteApnsVoipChannel(
            DeleteApnsVoipChannelRequest deleteApnsVoipChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsVoipChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsVoipChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsVoipChannelRequest, DeleteApnsVoipChannelResponse>()
                            .withOperationName("DeleteApnsVoipChannel")
                            .withMarshaller(new DeleteApnsVoipChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteApnsVoipChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteApnsVoipChannelRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteApnsVoipChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the DeleteApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsVoipSandboxChannelResponse> deleteApnsVoipSandboxChannel(
            DeleteApnsVoipSandboxChannelRequest deleteApnsVoipSandboxChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsVoipSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsVoipSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsVoipSandboxChannelRequest, DeleteApnsVoipSandboxChannelResponse>()
                            .withOperationName("DeleteApnsVoipSandboxChannel")
                            .withMarshaller(new DeleteApnsVoipSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteApnsVoipSandboxChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteApnsVoipSandboxChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteApnsVoipSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>().withOperationName("DeleteApp")
                            .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAppRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAppRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteBaiduChannelRequest
     * @return A Java Future containing the result of the DeleteBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBaiduChannelResponse> deleteBaiduChannel(DeleteBaiduChannelRequest deleteBaiduChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBaiduChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBaiduChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBaiduChannelRequest, DeleteBaiduChannelResponse>()
                            .withOperationName("DeleteBaiduChannel")
                            .withMarshaller(new DeleteBaiduChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBaiduChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteBaiduChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteBaiduChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a campaign from an application.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                            .withOperationName("DeleteCampaign")
                            .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCampaignRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteCampaignRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the email channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteEmailChannelRequest
     * @return A Java Future containing the result of the DeleteEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailChannelResponse> deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEmailChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEmailChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailChannelRequest, DeleteEmailChannelResponse>()
                            .withOperationName("DeleteEmailChannel")
                            .withMarshaller(new DeleteEmailChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEmailChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEmailChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteEmailChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the email channel.
     * </p>
     *
     * @param deleteEmailTemplateRequest
     * @return A Java Future containing the result of the DeleteEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(
            DeleteEmailTemplateRequest deleteEmailTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailTemplateRequest, DeleteEmailTemplateResponse>()
                            .withOperationName("DeleteEmailTemplate")
                            .withMarshaller(new DeleteEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEmailTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEmailTemplateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an endpoint from an application.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                            .withOperationName("DeleteEndpoint")
                            .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEndpointRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the event stream for an application.
     * </p>
     *
     * @param deleteEventStreamRequest
     * @return A Java Future containing the result of the DeleteEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventStreamResponse> deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventStreamRequest, DeleteEventStreamResponse>()
                            .withOperationName("DeleteEventStream")
                            .withMarshaller(new DeleteEventStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEventStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEventStreamRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteEventStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteGcmChannelRequest
     * @return A Java Future containing the result of the DeleteGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGcmChannelResponse> deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGcmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGcmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGcmChannelRequest, DeleteGcmChannelResponse>()
                            .withOperationName("DeleteGcmChannel")
                            .withMarshaller(new DeleteGcmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGcmChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteGcmChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteGcmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a journey from an application.
     * </p>
     *
     * @param deleteJourneyRequest
     * @return A Java Future containing the result of the DeleteJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteJourney
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteJourneyResponse> deleteJourney(DeleteJourneyRequest deleteJourneyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteJourneyRequest, DeleteJourneyResponse>()
                            .withOperationName("DeleteJourney")
                            .withMarshaller(new DeleteJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteJourneyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteJourneyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through a push notification channel.
     * </p>
     *
     * @param deletePushTemplateRequest
     * @return A Java Future containing the result of the DeletePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeletePushTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePushTemplateResponse> deletePushTemplate(DeletePushTemplateRequest deletePushTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePushTemplateRequest, DeletePushTemplateResponse>()
                            .withOperationName("DeletePushTemplate")
                            .withMarshaller(new DeletePushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePushTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePushTemplateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeletePushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param deleteRecommenderConfigurationRequest
     * @return A Java Future containing the result of the DeleteRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteRecommenderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRecommenderConfigurationResponse> deleteRecommenderConfiguration(
            DeleteRecommenderConfigurationRequest deleteRecommenderConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommenderConfigurationRequest, DeleteRecommenderConfigurationResponse>()
                            .withOperationName("DeleteRecommenderConfiguration")
                            .withMarshaller(new DeleteRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRecommenderConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRecommenderConfigurationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a segment from an application.
     * </p>
     *
     * @param deleteSegmentRequest
     * @return A Java Future containing the result of the DeleteSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSegmentResponse> deleteSegment(DeleteSegmentRequest deleteSegmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSegmentRequest, DeleteSegmentResponse>()
                            .withOperationName("DeleteSegment")
                            .withMarshaller(new DeleteSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSegmentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSegmentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteSmsChannelRequest
     * @return A Java Future containing the result of the DeleteSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSmsChannelResponse> deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSmsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSmsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSmsChannelRequest, DeleteSmsChannelResponse>()
                            .withOperationName("DeleteSmsChannel")
                            .withMarshaller(new DeleteSmsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSmsChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSmsChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteSmsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the SMS channel.
     * </p>
     *
     * @param deleteSmsTemplateRequest
     * @return A Java Future containing the result of the DeleteSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSmsTemplateResponse> deleteSmsTemplate(DeleteSmsTemplateRequest deleteSmsTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSmsTemplateRequest, DeleteSmsTemplateResponse>()
                            .withOperationName("DeleteSmsTemplate")
                            .withMarshaller(new DeleteSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSmsTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSmsTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param deleteUserEndpointsRequest
     * @return A Java Future containing the result of the DeleteUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserEndpointsResponse> deleteUserEndpoints(
            DeleteUserEndpointsRequest deleteUserEndpointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserEndpointsRequest, DeleteUserEndpointsResponse>()
                            .withOperationName("DeleteUserEndpoints")
                            .withMarshaller(new DeleteUserEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserEndpointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteUserEndpointsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteUserEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteVoiceChannelRequest
     * @return A Java Future containing the result of the DeleteVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceChannelResponse> deleteVoiceChannel(DeleteVoiceChannelRequest deleteVoiceChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceChannelRequest, DeleteVoiceChannelResponse>()
                            .withOperationName("DeleteVoiceChannel")
                            .withMarshaller(new DeleteVoiceChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteVoiceChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the voice channel.
     * </p>
     *
     * @param deleteVoiceTemplateRequest
     * @return A Java Future containing the result of the DeleteVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceTemplateResponse> deleteVoiceTemplate(
            DeleteVoiceTemplateRequest deleteVoiceTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceTemplateRequest, DeleteVoiceTemplateResponse>()
                            .withOperationName("DeleteVoiceTemplate")
                            .withMarshaller(new DeleteVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVoiceTemplateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the ADM channel for an application.
     * </p>
     *
     * @param getAdmChannelRequest
     * @return A Java Future containing the result of the GetAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAdmChannelResponse> getAdmChannel(GetAdmChannelRequest getAdmChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAdmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAdmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAdmChannelRequest, GetAdmChannelResponse>()
                            .withOperationName("GetAdmChannel")
                            .withMarshaller(new GetAdmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAdmChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAdmChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAdmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs channel for an application.
     * </p>
     *
     * @param getApnsChannelRequest
     * @return A Java Future containing the result of the GetApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsChannelResponse> getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsChannelRequest, GetApnsChannelResponse>()
                            .withOperationName("GetApnsChannel")
                            .withMarshaller(new GetApnsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApnsChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApnsChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetApnsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     * </p>
     *
     * @param getApnsSandboxChannelRequest
     * @return A Java Future containing the result of the GetApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsSandboxChannelResponse> getApnsSandboxChannel(
            GetApnsSandboxChannelRequest getApnsSandboxChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsSandboxChannelRequest, GetApnsSandboxChannelResponse>()
                            .withOperationName("GetApnsSandboxChannel")
                            .withMarshaller(new GetApnsSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApnsSandboxChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApnsSandboxChannelRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetApnsSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     * </p>
     *
     * @param getApnsVoipChannelRequest
     * @return A Java Future containing the result of the GetApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsVoipChannelResponse> getApnsVoipChannel(GetApnsVoipChannelRequest getApnsVoipChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsVoipChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsVoipChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsVoipChannelRequest, GetApnsVoipChannelResponse>()
                            .withOperationName("GetApnsVoipChannel")
                            .withMarshaller(new GetApnsVoipChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApnsVoipChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApnsVoipChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetApnsVoipChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     * </p>
     *
     * @param getApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the GetApnsVoipSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsVoipSandboxChannelResponse> getApnsVoipSandboxChannel(
            GetApnsVoipSandboxChannelRequest getApnsVoipSandboxChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsVoipSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsVoipSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsVoipSandboxChannelRequest, GetApnsVoipSandboxChannelResponse>()
                            .withOperationName("GetApnsVoipSandboxChannel")
                            .withMarshaller(new GetApnsVoipSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApnsVoipSandboxChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApnsVoipSandboxChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetApnsVoipSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     *
     * @param getAppRequest
     * @return A Java Future containing the result of the GetApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAppResponse> getApp(GetAppRequest getAppRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAppRequest, GetAppResponse>().withOperationName("GetApp")
                            .withMarshaller(new GetAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAppRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAppRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     * </p>
     *
     * @param getApplicationDateRangeKpiRequest
     * @return A Java Future containing the result of the GetApplicationDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationDateRangeKpi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationDateRangeKpiResponse> getApplicationDateRangeKpi(
            GetApplicationDateRangeKpiRequest getApplicationDateRangeKpiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationDateRangeKpiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApplicationDateRangeKpiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationDateRangeKpiRequest, GetApplicationDateRangeKpiResponse>()
                            .withOperationName("GetApplicationDateRangeKpi")
                            .withMarshaller(new GetApplicationDateRangeKpiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApplicationDateRangeKpiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApplicationDateRangeKpiRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetApplicationDateRangeKpiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the settings for an application.
     * </p>
     *
     * @param getApplicationSettingsRequest
     * @return A Java Future containing the result of the GetApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationSettingsResponse> getApplicationSettings(
            GetApplicationSettingsRequest getApplicationSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApplicationSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationSettingsRequest, GetApplicationSettingsResponse>()
                            .withOperationName("GetApplicationSettings")
                            .withMarshaller(new GetApplicationSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApplicationSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApplicationSettingsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetApplicationSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param getAppsRequest
     * @return A Java Future containing the result of the GetApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAppsResponse> getApps(GetAppsRequest getAppsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAppsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAppsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAppsRequest, GetAppsResponse>().withOperationName("GetApps")
                            .withMarshaller(new GetAppsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAppsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAppsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAppsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the Baidu channel for an application.
     * </p>
     *
     * @param getBaiduChannelRequest
     * @return A Java Future containing the result of the GetBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBaiduChannelResponse> getBaiduChannel(GetBaiduChannelRequest getBaiduChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBaiduChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBaiduChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBaiduChannelRequest, GetBaiduChannelResponse>()
                            .withOperationName("GetBaiduChannel")
                            .withMarshaller(new GetBaiduChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBaiduChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getBaiduChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetBaiduChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return A Java Future containing the result of the GetCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignResponse> getCampaign(GetCampaignRequest getCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignRequest, GetCampaignResponse>()
                            .withOperationName("GetCampaign").withMarshaller(new GetCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCampaignRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCampaignRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the activities for a campaign.
     * </p>
     *
     * @param getCampaignActivitiesRequest
     * @return A Java Future containing the result of the GetCampaignActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignActivitiesResponse> getCampaignActivities(
            GetCampaignActivitiesRequest getCampaignActivitiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignActivitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignActivities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignActivitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignActivitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignActivitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignActivitiesRequest, GetCampaignActivitiesResponse>()
                            .withOperationName("GetCampaignActivities")
                            .withMarshaller(new GetCampaignActivitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCampaignActivitiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCampaignActivitiesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetCampaignActivitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     * </p>
     *
     * @param getCampaignDateRangeKpiRequest
     * @return A Java Future containing the result of the GetCampaignDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignDateRangeKpi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignDateRangeKpiResponse> getCampaignDateRangeKpi(
            GetCampaignDateRangeKpiRequest getCampaignDateRangeKpiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignDateRangeKpiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignDateRangeKpiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignDateRangeKpiRequest, GetCampaignDateRangeKpiResponse>()
                            .withOperationName("GetCampaignDateRangeKpi")
                            .withMarshaller(new GetCampaignDateRangeKpiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCampaignDateRangeKpiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCampaignDateRangeKpiRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetCampaignDateRangeKpiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     * </p>
     *
     * @param getCampaignVersionRequest
     * @return A Java Future containing the result of the GetCampaignVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignVersionResponse> getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignVersionRequest, GetCampaignVersionResponse>()
                            .withOperationName("GetCampaignVersion")
                            .withMarshaller(new GetCampaignVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCampaignVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCampaignVersionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetCampaignVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     * </p>
     *
     * @param getCampaignVersionsRequest
     * @return A Java Future containing the result of the GetCampaignVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignVersionsResponse> getCampaignVersions(
            GetCampaignVersionsRequest getCampaignVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignVersionsRequest, GetCampaignVersionsResponse>()
                            .withOperationName("GetCampaignVersions")
                            .withMarshaller(new GetCampaignVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCampaignVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCampaignVersionsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetCampaignVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are
     * associated with an application.
     * </p>
     *
     * @param getCampaignsRequest
     * @return A Java Future containing the result of the GetCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignsResponse> getCampaigns(GetCampaignsRequest getCampaignsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCampaignsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignsRequest, GetCampaignsResponse>()
                            .withOperationName("GetCampaigns").withMarshaller(new GetCampaignsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCampaignsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCampaignsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetCampaignsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the history and status of each channel for an application.
     * </p>
     *
     * @param getChannelsRequest
     * @return A Java Future containing the result of the GetChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetChannelsResponse> getChannels(GetChannelsRequest getChannelsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetChannelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetChannelsRequest, GetChannelsResponse>()
                            .withOperationName("GetChannels").withMarshaller(new GetChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getChannelsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getChannelsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the email channel for an application.
     * </p>
     *
     * @param getEmailChannelRequest
     * @return A Java Future containing the result of the GetEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEmailChannelResponse> getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEmailChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEmailChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEmailChannelRequest, GetEmailChannelResponse>()
                            .withOperationName("GetEmailChannel")
                            .withMarshaller(new GetEmailChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getEmailChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getEmailChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetEmailChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param getEmailTemplateRequest
     * @return A Java Future containing the result of the GetEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEmailTemplateRequest, GetEmailTemplateResponse>()
                            .withOperationName("GetEmailTemplate")
                            .withMarshaller(new GetEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getEmailTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getEmailTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     * </p>
     *
     * @param getEndpointRequest
     * @return A Java Future containing the result of the GetEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEndpointResponse> getEndpoint(GetEndpointRequest getEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEndpointRequest, GetEndpointResponse>()
                            .withOperationName("GetEndpoint").withMarshaller(new GetEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getEndpointRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the event stream settings for an application.
     * </p>
     *
     * @param getEventStreamRequest
     * @return A Java Future containing the result of the GetEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventStreamResponse> getEventStream(GetEventStreamRequest getEventStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventStreamRequest, GetEventStreamResponse>()
                            .withOperationName("GetEventStream")
                            .withMarshaller(new GetEventStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getEventStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getEventStreamRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetEventStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific export job for an application.
     * </p>
     *
     * @param getExportJobRequest
     * @return A Java Future containing the result of the GetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportJobResponse> getExportJob(GetExportJobRequest getExportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportJobRequest, GetExportJobResponse>()
                            .withOperationName("GetExportJob").withMarshaller(new GetExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getExportJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getExportJobRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the export jobs for an application.
     * </p>
     *
     * @param getExportJobsRequest
     * @return A Java Future containing the result of the GetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportJobsResponse> getExportJobs(GetExportJobsRequest getExportJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportJobsRequest, GetExportJobsResponse>()
                            .withOperationName("GetExportJobs")
                            .withMarshaller(new GetExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getExportJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getExportJobsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the GCM channel for an application.
     * </p>
     *
     * @param getGcmChannelRequest
     * @return A Java Future containing the result of the GetGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGcmChannelResponse> getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGcmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGcmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGcmChannelRequest, GetGcmChannelResponse>()
                            .withOperationName("GetGcmChannel")
                            .withMarshaller(new GetGcmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGcmChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getGcmChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetGcmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific import job for an application.
     * </p>
     *
     * @param getImportJobRequest
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportJobRequest, GetImportJobResponse>()
                            .withOperationName("GetImportJob").withMarshaller(new GetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImportJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getImportJobRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the import jobs for an application.
     * </p>
     *
     * @param getImportJobsRequest
     * @return A Java Future containing the result of the GetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportJobsResponse> getImportJobs(GetImportJobsRequest getImportJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportJobsRequest, GetImportJobsResponse>()
                            .withOperationName("GetImportJobs")
                            .withMarshaller(new GetImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getImportJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getImportJobsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a journey.
     * </p>
     *
     * @param getJourneyRequest
     * @return A Java Future containing the result of the GetJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourney
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyResponse> getJourney(GetJourneyRequest getJourneyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyRequest, GetJourneyResponse>().withOperationName("GetJourney")
                            .withMarshaller(new GetJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getJourneyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJourneyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     * </p>
     *
     * @param getJourneyDateRangeKpiRequest
     * @return A Java Future containing the result of the GetJourneyDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyDateRangeKpi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyDateRangeKpiResponse> getJourneyDateRangeKpi(
            GetJourneyDateRangeKpiRequest getJourneyDateRangeKpiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetJourneyDateRangeKpiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyDateRangeKpiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyDateRangeKpiRequest, GetJourneyDateRangeKpiResponse>()
                            .withOperationName("GetJourneyDateRangeKpi")
                            .withMarshaller(new GetJourneyDateRangeKpiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getJourneyDateRangeKpiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJourneyDateRangeKpiRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetJourneyDateRangeKpiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     * </p>
     *
     * @param getJourneyExecutionActivityMetricsRequest
     * @return A Java Future containing the result of the GetJourneyExecutionActivityMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionActivityMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyExecutionActivityMetricsResponse> getJourneyExecutionActivityMetrics(
            GetJourneyExecutionActivityMetricsRequest getJourneyExecutionActivityMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getJourneyExecutionActivityMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyExecutionActivityMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyExecutionActivityMetricsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetJourneyExecutionActivityMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyExecutionActivityMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyExecutionActivityMetricsRequest, GetJourneyExecutionActivityMetricsResponse>()
                            .withOperationName("GetJourneyExecutionActivityMetrics")
                            .withMarshaller(new GetJourneyExecutionActivityMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getJourneyExecutionActivityMetricsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJourneyExecutionActivityMetricsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetJourneyExecutionActivityMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     * </p>
     *
     * @param getJourneyExecutionMetricsRequest
     * @return A Java Future containing the result of the GetJourneyExecutionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyExecutionMetricsResponse> getJourneyExecutionMetrics(
            GetJourneyExecutionMetricsRequest getJourneyExecutionMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyExecutionMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyExecutionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyExecutionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetJourneyExecutionMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyExecutionMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyExecutionMetricsRequest, GetJourneyExecutionMetricsResponse>()
                            .withOperationName("GetJourneyExecutionMetrics")
                            .withMarshaller(new GetJourneyExecutionMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getJourneyExecutionMetricsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJourneyExecutionMetricsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetJourneyExecutionMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through a push notification
     * channel.
     * </p>
     *
     * @param getPushTemplateRequest
     * @return A Java Future containing the result of the GetPushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetPushTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetPushTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPushTemplateResponse> getPushTemplate(GetPushTemplateRequest getPushTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPushTemplateRequest, GetPushTemplateResponse>()
                            .withOperationName("GetPushTemplate")
                            .withMarshaller(new GetPushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPushTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPushTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetPushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param getRecommenderConfigurationRequest
     * @return A Java Future containing the result of the GetRecommenderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRecommenderConfigurationResponse> getRecommenderConfiguration(
            GetRecommenderConfigurationRequest getRecommenderConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRecommenderConfigurationRequest, GetRecommenderConfigurationResponse>()
                            .withOperationName("GetRecommenderConfiguration")
                            .withMarshaller(new GetRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRecommenderConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRecommenderConfigurationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the recommender model configurations that are associated with your Amazon
     * Pinpoint account.
     * </p>
     *
     * @param getRecommenderConfigurationsRequest
     * @return A Java Future containing the result of the GetRecommenderConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRecommenderConfigurationsResponse> getRecommenderConfigurations(
            GetRecommenderConfigurationsRequest getRecommenderConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommenderConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRecommenderConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRecommenderConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRecommenderConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRecommenderConfigurationsRequest, GetRecommenderConfigurationsResponse>()
                            .withOperationName("GetRecommenderConfigurations")
                            .withMarshaller(new GetRecommenderConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRecommenderConfigurationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRecommenderConfigurationsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetRecommenderConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's
     * associated with an application.
     * </p>
     *
     * @param getSegmentRequest
     * @return A Java Future containing the result of the GetSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentResponse> getSegment(GetSegmentRequest getSegmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentRequest, GetSegmentResponse>().withOperationName("GetSegment")
                            .withMarshaller(new GetSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSegmentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSegmentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the export jobs for a segment.
     * </p>
     *
     * @param getSegmentExportJobsRequest
     * @return A Java Future containing the result of the GetSegmentExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentExportJobsResponse> getSegmentExportJobs(
            GetSegmentExportJobsRequest getSegmentExportJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentExportJobsRequest, GetSegmentExportJobsResponse>()
                            .withOperationName("GetSegmentExportJobs")
                            .withMarshaller(new GetSegmentExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSegmentExportJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSegmentExportJobsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetSegmentExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the import jobs for a segment.
     * </p>
     *
     * @param getSegmentImportJobsRequest
     * @return A Java Future containing the result of the GetSegmentImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentImportJobsResponse> getSegmentImportJobs(
            GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentImportJobsRequest, GetSegmentImportJobsResponse>()
                            .withOperationName("GetSegmentImportJobs")
                            .withMarshaller(new GetSegmentImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSegmentImportJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSegmentImportJobsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetSegmentImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment
     * that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionRequest
     * @return A Java Future containing the result of the GetSegmentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentVersionResponse> getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentVersionRequest, GetSegmentVersionResponse>()
                            .withOperationName("GetSegmentVersion")
                            .withMarshaller(new GetSegmentVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSegmentVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSegmentVersionRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSegmentVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific
     * segment that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionsRequest
     * @return A Java Future containing the result of the GetSegmentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentVersionsResponse> getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentVersionsRequest, GetSegmentVersionsResponse>()
                            .withOperationName("GetSegmentVersions")
                            .withMarshaller(new GetSegmentVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSegmentVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSegmentVersionsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetSegmentVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are
     * associated with an application.
     * </p>
     *
     * @param getSegmentsRequest
     * @return A Java Future containing the result of the GetSegments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentsResponse> getSegments(GetSegmentsRequest getSegmentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSegmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentsRequest, GetSegmentsResponse>()
                            .withOperationName("GetSegments").withMarshaller(new GetSegmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSegmentsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSegmentsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSegmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the SMS channel for an application.
     * </p>
     *
     * @param getSmsChannelRequest
     * @return A Java Future containing the result of the GetSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSmsChannelResponse> getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSmsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSmsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSmsChannelRequest, GetSmsChannelResponse>()
                            .withOperationName("GetSmsChannel")
                            .withMarshaller(new GetSmsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSmsChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSmsChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSmsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param getSmsTemplateRequest
     * @return A Java Future containing the result of the GetSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSmsTemplateResponse> getSmsTemplate(GetSmsTemplateRequest getSmsTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSmsTemplateRequest, GetSmsTemplateResponse>()
                            .withOperationName("GetSmsTemplate")
                            .withMarshaller(new GetSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSmsTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSmsTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param getUserEndpointsRequest
     * @return A Java Future containing the result of the GetUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserEndpointsResponse> getUserEndpoints(GetUserEndpointsRequest getUserEndpointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUserEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserEndpointsRequest, GetUserEndpointsResponse>()
                            .withOperationName("GetUserEndpoints")
                            .withMarshaller(new GetUserEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUserEndpointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUserEndpointsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUserEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the voice channel for an application.
     * </p>
     *
     * @param getVoiceChannelRequest
     * @return A Java Future containing the result of the GetVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceChannelResponse> getVoiceChannel(GetVoiceChannelRequest getVoiceChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceChannelRequest, GetVoiceChannelResponse>()
                            .withOperationName("GetVoiceChannel")
                            .withMarshaller(new GetVoiceChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetVoiceChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param getVoiceTemplateRequest
     * @return A Java Future containing the result of the GetVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceTemplateResponse> getVoiceTemplate(GetVoiceTemplateRequest getVoiceTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceTemplateRequest, GetVoiceTemplateResponse>()
                            .withOperationName("GetVoiceTemplate")
                            .withMarshaller(new GetVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVoiceTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the journeys that are
     * associated with an application.
     * </p>
     *
     * @param listJourneysRequest
     * @return A Java Future containing the result of the ListJourneys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListJourneys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListJourneys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListJourneysResponse> listJourneys(ListJourneysRequest listJourneysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJourneysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJourneys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListJourneysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListJourneysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListJourneysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJourneysRequest, ListJourneysResponse>()
                            .withOperationName("ListJourneys").withMarshaller(new ListJourneysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listJourneysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listJourneysRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListJourneysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or
     * segment.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the versions of a specific message template.
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A Java Future containing the result of the ListTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplateVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(
            ListTemplateVersionsRequest listTemplateVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTemplateVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTemplateVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTemplateVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTemplateVersionsRequest, ListTemplateVersionsResponse>()
                            .withOperationName("ListTemplateVersions")
                            .withMarshaller(new ListTemplateVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTemplateVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTemplateVersionsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListTemplateVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param listTemplatesRequest
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTemplatesRequest, ListTemplatesResponse>()
                            .withOperationName("ListTemplates")
                            .withMarshaller(new ListTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTemplatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTemplatesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a phone number.
     * </p>
     *
     * @param phoneNumberValidateRequest
     * @return A Java Future containing the result of the PhoneNumberValidate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PhoneNumberValidate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PhoneNumberValidateResponse> phoneNumberValidate(
            PhoneNumberValidateRequest phoneNumberValidateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, phoneNumberValidateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PhoneNumberValidate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PhoneNumberValidateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PhoneNumberValidateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PhoneNumberValidateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PhoneNumberValidateRequest, PhoneNumberValidateResponse>()
                            .withOperationName("PhoneNumberValidate")
                            .withMarshaller(new PhoneNumberValidateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(phoneNumberValidateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = phoneNumberValidateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<PhoneNumberValidateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new event stream for an application or updates the settings of an existing event stream for an
     * application.
     * </p>
     *
     * @param putEventStreamRequest
     * @return A Java Future containing the result of the PutEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutEventStreamResponse> putEventStream(PutEventStreamRequest putEventStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutEventStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEventStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEventStreamRequest, PutEventStreamResponse>()
                            .withOperationName("PutEventStream")
                            .withMarshaller(new PutEventStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putEventStreamRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putEventStreamRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutEventStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are
     * associated with.
     * </p>
     *
     * @param putEventsRequest
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutEventsResponse> putEvents(PutEventsRequest putEventsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEventsRequest, PutEventsResponse>().withOperationName("PutEvents")
                            .withMarshaller(new PutEventsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEventsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putEventsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an
     * application.
     * </p>
     *
     * @param removeAttributesRequest
     * @return A Java Future containing the result of the RemoveAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.RemoveAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveAttributesResponse> removeAttributes(RemoveAttributesRequest removeAttributesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveAttributesRequest, RemoveAttributesResponse>()
                            .withOperationName("RemoveAttributes")
                            .withMarshaller(new RemoveAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeAttributesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<RemoveAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and sends a direct message.
     * </p>
     *
     * @param sendMessagesRequest
     * @return A Java Future containing the result of the SendMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendMessagesResponse> sendMessages(SendMessagesRequest sendMessagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SendMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendMessagesRequest, SendMessagesResponse>()
                            .withOperationName("SendMessages").withMarshaller(new SendMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendMessagesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = sendMessagesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<SendMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and sends a message to a list of users.
     * </p>
     *
     * @param sendUsersMessagesRequest
     * @return A Java Future containing the result of the SendUsersMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendUsersMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendUsersMessagesResponse> sendUsersMessages(SendUsersMessagesRequest sendUsersMessagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendUsersMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendUsersMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendUsersMessagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendUsersMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendUsersMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendUsersMessagesRequest, SendUsersMessagesResponse>()
                            .withOperationName("SendUsersMessages")
                            .withMarshaller(new SendUsersMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendUsersMessagesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = sendUsersMessagesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<SendUsersMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an
     * application.
     * </p>
     *
     * @param updateAdmChannelRequest
     * @return A Java Future containing the result of the UpdateAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAdmChannelResponse> updateAdmChannel(UpdateAdmChannelRequest updateAdmChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAdmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAdmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAdmChannelRequest, UpdateAdmChannelResponse>()
                            .withOperationName("UpdateAdmChannel")
                            .withMarshaller(new UpdateAdmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAdmChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateAdmChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateAdmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an
     * application.
     * </p>
     *
     * @param updateApnsChannelRequest
     * @return A Java Future containing the result of the UpdateApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsChannelResponse> updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsChannelRequest, UpdateApnsChannelResponse>()
                            .withOperationName("UpdateApnsChannel")
                            .withMarshaller(new UpdateApnsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateApnsChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateApnsChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateApnsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox
     * channel for an application.
     * </p>
     *
     * @param updateApnsSandboxChannelRequest
     * @return A Java Future containing the result of the UpdateApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsSandboxChannelResponse> updateApnsSandboxChannel(
            UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsSandboxChannelRequest, UpdateApnsSandboxChannelResponse>()
                            .withOperationName("UpdateApnsSandboxChannel")
                            .withMarshaller(new UpdateApnsSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateApnsSandboxChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateApnsSandboxChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateApnsSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for
     * an application.
     * </p>
     *
     * @param updateApnsVoipChannelRequest
     * @return A Java Future containing the result of the UpdateApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsVoipChannelResponse> updateApnsVoipChannel(
            UpdateApnsVoipChannelRequest updateApnsVoipChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsVoipChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsVoipChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsVoipChannelRequest, UpdateApnsVoipChannelResponse>()
                            .withOperationName("UpdateApnsVoipChannel")
                            .withMarshaller(new UpdateApnsVoipChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateApnsVoipChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateApnsVoipChannelRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateApnsVoipChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP
     * sandbox channel for an application.
     * </p>
     *
     * @param updateApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the UpdateApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsVoipSandboxChannelResponse> updateApnsVoipSandboxChannel(
            UpdateApnsVoipSandboxChannelRequest updateApnsVoipSandboxChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsVoipSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsVoipSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsVoipSandboxChannelRequest, UpdateApnsVoipSandboxChannelResponse>()
                            .withOperationName("UpdateApnsVoipSandboxChannel")
                            .withMarshaller(new UpdateApnsVoipSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateApnsVoipSandboxChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateApnsVoipSandboxChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateApnsVoipSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings for an application.
     * </p>
     *
     * @param updateApplicationSettingsRequest
     * @return A Java Future containing the result of the UpdateApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApplicationSettingsResponse> updateApplicationSettings(
            UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplicationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApplicationSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApplicationSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResponse>()
                            .withOperationName("UpdateApplicationSettings")
                            .withMarshaller(new UpdateApplicationSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateApplicationSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateApplicationSettingsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateApplicationSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an
     * application.
     * </p>
     *
     * @param updateBaiduChannelRequest
     * @return A Java Future containing the result of the UpdateBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBaiduChannelResponse> updateBaiduChannel(UpdateBaiduChannelRequest updateBaiduChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBaiduChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBaiduChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBaiduChannelRequest, UpdateBaiduChannelResponse>()
                            .withOperationName("UpdateBaiduChannel")
                            .withMarshaller(new UpdateBaiduChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBaiduChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateBaiduChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateBaiduChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration and other settings for a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCampaignResponse> updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignRequest, UpdateCampaignResponse>()
                            .withOperationName("UpdateCampaign")
                            .withMarshaller(new UpdateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateCampaignRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateCampaignRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the email channel for an application or updates the status and settings of the email channel for an
     * application.
     * </p>
     *
     * @param updateEmailChannelRequest
     * @return A Java Future containing the result of the UpdateEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEmailChannelResponse> updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEmailChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEmailChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEmailChannelRequest, UpdateEmailChannelResponse>()
                            .withOperationName("UpdateEmailChannel")
                            .withMarshaller(new UpdateEmailChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateEmailChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateEmailChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateEmailChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the email channel.
     * </p>
     *
     * @param updateEmailTemplateRequest
     * @return A Java Future containing the result of the UpdateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(
            UpdateEmailTemplateRequest updateEmailTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEmailTemplateRequest, UpdateEmailTemplateResponse>()
                            .withOperationName("UpdateEmailTemplate")
                            .withMarshaller(new UpdateEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateEmailTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateEmailTemplateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an
     * application. You can also use this operation to define custom attributes for an endpoint. If an update includes
     * one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new
     * values.
     * </p>
     *
     * @param updateEndpointRequest
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointRequest, UpdateEndpointResponse>()
                            .withOperationName("UpdateEndpoint")
                            .withMarshaller(new UpdateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateEndpointRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing
     * endpoints for an application. You can also use this operation to define custom attributes for a batch of
     * endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites)
     * any existing values with the new values.
     * </p>
     *
     * @param updateEndpointsBatchRequest
     * @return A Java Future containing the result of the UpdateEndpointsBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpointsBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointsBatchResponse> updateEndpointsBatch(
            UpdateEndpointsBatchRequest updateEndpointsBatchRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointsBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpointsBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointsBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointsBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEndpointsBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointsBatchRequest, UpdateEndpointsBatchResponse>()
                            .withOperationName("UpdateEndpointsBatch")
                            .withMarshaller(new UpdateEndpointsBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateEndpointsBatchRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateEndpointsBatchRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateEndpointsBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an
     * application.
     * </p>
     *
     * @param updateGcmChannelRequest
     * @return A Java Future containing the result of the UpdateGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGcmChannelResponse> updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGcmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGcmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGcmChannelRequest, UpdateGcmChannelResponse>()
                            .withOperationName("UpdateGcmChannel")
                            .withMarshaller(new UpdateGcmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGcmChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateGcmChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateGcmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration and other settings for a journey.
     * </p>
     *
     * @param updateJourneyRequest
     * @return A Java Future containing the result of the UpdateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourney
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateJourneyResponse> updateJourney(UpdateJourneyRequest updateJourneyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJourneyRequest, UpdateJourneyResponse>()
                            .withOperationName("UpdateJourney")
                            .withMarshaller(new UpdateJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateJourneyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateJourneyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels (stops) an active journey.
     * </p>
     *
     * @param updateJourneyStateRequest
     * @return A Java Future containing the result of the UpdateJourneyState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourneyState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateJourneyStateResponse> updateJourneyState(UpdateJourneyStateRequest updateJourneyStateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJourneyStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJourneyState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateJourneyStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateJourneyStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateJourneyStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJourneyStateRequest, UpdateJourneyStateResponse>()
                            .withOperationName("UpdateJourneyState")
                            .withMarshaller(new UpdateJourneyStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateJourneyStateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateJourneyStateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateJourneyStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param updatePushTemplateRequest
     * @return A Java Future containing the result of the UpdatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdatePushTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePushTemplateResponse> updatePushTemplate(UpdatePushTemplateRequest updatePushTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePushTemplateRequest, UpdatePushTemplateResponse>()
                            .withOperationName("UpdatePushTemplate")
                            .withMarshaller(new UpdatePushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePushTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePushTemplateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdatePushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param updateRecommenderConfigurationRequest
     * @return A Java Future containing the result of the UpdateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateRecommenderConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRecommenderConfigurationResponse> updateRecommenderConfiguration(
            UpdateRecommenderConfigurationRequest updateRecommenderConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRecommenderConfigurationRequest, UpdateRecommenderConfigurationResponse>()
                            .withOperationName("UpdateRecommenderConfiguration")
                            .withMarshaller(new UpdateRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateRecommenderConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRecommenderConfigurationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param updateSegmentRequest
     * @return A Java Future containing the result of the UpdateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSegmentResponse> updateSegment(UpdateSegmentRequest updateSegmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSegmentRequest, UpdateSegmentResponse>()
                            .withOperationName("UpdateSegment")
                            .withMarshaller(new UpdateSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSegmentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSegmentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an
     * application.
     * </p>
     *
     * @param updateSmsChannelRequest
     * @return A Java Future containing the result of the UpdateSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmsChannelResponse> updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmsChannelRequest, UpdateSmsChannelResponse>()
                            .withOperationName("UpdateSmsChannel")
                            .withMarshaller(new UpdateSmsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSmsChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSmsChannelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateSmsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param updateSmsTemplateRequest
     * @return A Java Future containing the result of the UpdateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmsTemplateResponse> updateSmsTemplate(UpdateSmsTemplateRequest updateSmsTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmsTemplateRequest, UpdateSmsTemplateResponse>()
                            .withOperationName("UpdateSmsTemplate")
                            .withMarshaller(new UpdateSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSmsTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSmsTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the status of a specific version of a message template to <i>active</i>.
     * </p>
     *
     * @param updateTemplateActiveVersionRequest
     * @return A Java Future containing the result of the UpdateTemplateActiveVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateTemplateActiveVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateTemplateActiveVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTemplateActiveVersionResponse> updateTemplateActiveVersion(
            UpdateTemplateActiveVersionRequest updateTemplateActiveVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplateActiveVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplateActiveVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTemplateActiveVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTemplateActiveVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTemplateActiveVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTemplateActiveVersionRequest, UpdateTemplateActiveVersionResponse>()
                            .withOperationName("UpdateTemplateActiveVersion")
                            .withMarshaller(new UpdateTemplateActiveVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTemplateActiveVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTemplateActiveVersionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateTemplateActiveVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an
     * application.
     * </p>
     *
     * @param updateVoiceChannelRequest
     * @return A Java Future containing the result of the UpdateVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceChannelResponse> updateVoiceChannel(UpdateVoiceChannelRequest updateVoiceChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceChannelRequest, UpdateVoiceChannelResponse>()
                            .withOperationName("UpdateVoiceChannel")
                            .withMarshaller(new UpdateVoiceChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVoiceChannelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateVoiceChannelRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateVoiceChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param updateVoiceTemplateRequest
     * @return A Java Future containing the result of the UpdateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceTemplateResponse> updateVoiceTemplate(
            UpdateVoiceTemplateRequest updateVoiceTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceTemplateRequest, UpdateVoiceTemplateResponse>()
                            .withOperationName("UpdateVoiceTemplate")
                            .withMarshaller(new UpdateVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVoiceTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateVoiceTemplateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PinpointException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MethodNotAllowedException")
                                .exceptionBuilderSupplier(MethodNotAllowedException::builder).httpStatusCode(405).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PayloadTooLargeException")
                                .exceptionBuilderSupplier(PayloadTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
