/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignHook implements SdkPojo, Serializable, ToCopyableBuilder<CampaignHook.Builder, CampaignHook> {
    private static final SdkField<String> LAMBDA_FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignHook::lambdaFunctionName)).setter(setter(Builder::lambdaFunctionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionName").build())
            .build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignHook::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> WEB_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignHook::webUrl)).setter(setter(Builder::webUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTION_NAME_FIELD,
            MODE_FIELD, WEB_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lambdaFunctionName;

    private final String mode;

    private final String webUrl;

    private CampaignHook(BuilderImpl builder) {
        this.lambdaFunctionName = builder.lambdaFunctionName;
        this.mode = builder.mode;
        this.webUrl = builder.webUrl;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a
     * segment for a campaign.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to
     *         customize a segment for a campaign.
     */
    public String lambdaFunctionName() {
        return lambdaFunctionName;
    }

    /**
     * <p>
     * The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FILTER - Invoke the function to customize the segment that's used by a campaign.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This
     * functionality is not supported anymore. To send a campaign through a custom channel, use the
     * CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FILTER - Invoke the function to customize the segment that's used by a campaign.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel.
     *         This functionality is not supported anymore. To send a campaign through a custom channel, use the
     *         CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
     *         </p>
     *         </li>
     * @see Mode
     */
    public Mode mode() {
        return Mode.fromValue(mode);
    }

    /**
     * <p>
     * The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FILTER - Invoke the function to customize the segment that's used by a campaign.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This
     * functionality is not supported anymore. To send a campaign through a custom channel, use the
     * CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FILTER - Invoke the function to customize the segment that's used by a campaign.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel.
     *         This functionality is not supported anymore. To send a campaign through a custom channel, use the
     *         CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
     *         </p>
     *         </li>
     * @see Mode
     */
    public String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.
     * </p>
     * 
     * @return <p>
     *         The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.
     *         </p>
     */
    public String webUrl() {
        return webUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionName());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignHook)) {
            return false;
        }
        CampaignHook other = (CampaignHook) obj;
        return Objects.equals(lambdaFunctionName(), other.lambdaFunctionName())
                && Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(webUrl(), other.webUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CampaignHook").add("LambdaFunctionName", lambdaFunctionName()).add("Mode", modeAsString())
                .add("WebUrl", webUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaFunctionName":
            return Optional.ofNullable(clazz.cast(lambdaFunctionName()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "WebUrl":
            return Optional.ofNullable(clazz.cast(webUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignHook, T> g) {
        return obj -> g.apply((CampaignHook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignHook> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a
         * segment for a campaign.
         * </p>
         * 
         * @param lambdaFunctionName
         *        The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to
         *        customize a segment for a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionName(String lambdaFunctionName);

        /**
         * <p>
         * The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FILTER - Invoke the function to customize the segment that's used by a campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This
         * functionality is not supported anymore. To send a campaign through a custom channel, use the
         * CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FILTER - Invoke the function to customize the segment that's used by a campaign.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel.
         *        This functionality is not supported anymore. To send a campaign through a custom channel, use the
         *        CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
         *        </p>
         *        </li>
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FILTER - Invoke the function to customize the segment that's used by a campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This
         * functionality is not supported anymore. To send a campaign through a custom channel, use the
         * CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FILTER - Invoke the function to customize the segment that's used by a campaign.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel.
         *        This functionality is not supported anymore. To send a campaign through a custom channel, use the
         *        CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.
         *        </p>
         *        </li>
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(Mode mode);

        /**
         * <p>
         * The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.
         * </p>
         * 
         * @param webUrl
         *        <p>
         *        The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webUrl(String webUrl);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaFunctionName;

        private String mode;

        private String webUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignHook model) {
            lambdaFunctionName(model.lambdaFunctionName);
            mode(model.mode);
            webUrl(model.webUrl);
        }

        public final String getLambdaFunctionName() {
            return lambdaFunctionName;
        }

        @Override
        public final Builder lambdaFunctionName(String lambdaFunctionName) {
            this.lambdaFunctionName = lambdaFunctionName;
            return this;
        }

        public final void setLambdaFunctionName(String lambdaFunctionName) {
            this.lambdaFunctionName = lambdaFunctionName;
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getWebUrl() {
            return webUrl;
        }

        @Override
        public final Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public final void setWebUrl(String webUrl) {
            this.webUrl = webUrl;
        }

        @Override
        public CampaignHook build() {
            return new CampaignHook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
