/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the conditions to evaluate for an activity in a journey, and how to evaluate those conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<List<SimpleCondition>> CONDITIONS_FIELD = SdkField
            .<List<SimpleCondition>> builder(MarshallingType.LIST)
            .getter(getter(Condition::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimpleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimpleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Condition::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITIONS_FIELD,
            OPERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SimpleCondition> conditions;

    private final String operator;

    private Condition(BuilderImpl builder) {
        this.conditions = builder.conditions;
        this.operator = builder.operator;
    }

    /**
     * Returns true if the Conditions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditions to evaluate for the activity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConditions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The conditions to evaluate for the activity.
     */
    public List<SimpleCondition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for an
     * activity, whether both or only one of the conditions must be met for the activity to be performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions
     *         for an activity, whether both or only one of the conditions must be met for the activity to be performed.
     * @see Operator
     */
    public Operator operator() {
        return Operator.fromValue(operator);
    }

    /**
     * <p>
     * Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for an
     * activity, whether both or only one of the conditions must be met for the activity to be performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions
     *         for an activity, whether both or only one of the conditions must be met for the activity to be performed.
     * @see Operator
     */
    public String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditions());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(conditions(), other.conditions()) && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Condition").add("Conditions", conditions()).add("Operator", operatorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * The conditions to evaluate for the activity.
         * </p>
         * 
         * @param conditions
         *        The conditions to evaluate for the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<SimpleCondition> conditions);

        /**
         * <p>
         * The conditions to evaluate for the activity.
         * </p>
         * 
         * @param conditions
         *        The conditions to evaluate for the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(SimpleCondition... conditions);

        /**
         * <p>
         * The conditions to evaluate for the activity.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimpleCondition>.Builder} avoiding the need
         * to create one manually via {@link List<SimpleCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimpleCondition>.Builder#build()} is called immediately and
         * its result is passed to {@link #conditions(List<SimpleCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link List<SimpleCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(List<SimpleCondition>)
         */
        Builder conditions(Consumer<SimpleCondition.Builder>... conditions);

        /**
         * <p>
         * Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for
         * an activity, whether both or only one of the conditions must be met for the activity to be performed.
         * </p>
         * 
         * @param operator
         *        Specifies how to handle multiple conditions for the activity. For example, if you specify two
         *        conditions for an activity, whether both or only one of the conditions must be met for the activity to
         *        be performed.
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder operator(String operator);

        /**
         * <p>
         * Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for
         * an activity, whether both or only one of the conditions must be met for the activity to be performed.
         * </p>
         * 
         * @param operator
         *        Specifies how to handle multiple conditions for the activity. For example, if you specify two
         *        conditions for an activity, whether both or only one of the conditions must be met for the activity to
         *        be performed.
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder operator(Operator operator);
    }

    static final class BuilderImpl implements Builder {
        private List<SimpleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            conditions(model.conditions);
            operator(model.operator);
        }

        public final Collection<SimpleCondition.Builder> getConditions() {
            return conditions != null ? conditions.stream().map(SimpleCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<SimpleCondition> conditions) {
            this.conditions = ListOfSimpleConditionCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(SimpleCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<SimpleCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> SimpleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConditions(Collection<SimpleCondition.BuilderImpl> conditions) {
            this.conditions = ListOfSimpleConditionCopier.copyFromBuilder(conditions);
        }

        public final String getOperator() {
            return operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(Operator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
