/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a yes/no split activity in a journey. This type of activity sends participants down one of
 * two paths in a journey, based on conditions that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalSplitActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalSplitActivity.Builder, ConditionalSplitActivity> {
    private static final SdkField<Condition> CONDITION_FIELD = SdkField.<Condition> builder(MarshallingType.SDK_POJO)
            .getter(getter(ConditionalSplitActivity::condition)).setter(setter(Builder::condition))
            .constructor(Condition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<WaitTime> EVALUATION_WAIT_TIME_FIELD = SdkField.<WaitTime> builder(MarshallingType.SDK_POJO)
            .getter(getter(ConditionalSplitActivity::evaluationWaitTime)).setter(setter(Builder::evaluationWaitTime))
            .constructor(WaitTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationWaitTime").build())
            .build();

    private static final SdkField<String> FALSE_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConditionalSplitActivity::falseActivity)).setter(setter(Builder::falseActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FalseActivity").build()).build();

    private static final SdkField<String> TRUE_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConditionalSplitActivity::trueActivity)).setter(setter(Builder::trueActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrueActivity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD,
            EVALUATION_WAIT_TIME_FIELD, FALSE_ACTIVITY_FIELD, TRUE_ACTIVITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Condition condition;

    private final WaitTime evaluationWaitTime;

    private final String falseActivity;

    private final String trueActivity;

    private ConditionalSplitActivity(BuilderImpl builder) {
        this.condition = builder.condition;
        this.evaluationWaitTime = builder.evaluationWaitTime;
        this.falseActivity = builder.falseActivity;
        this.trueActivity = builder.trueActivity;
    }

    /**
     * <p>
     * The conditions that define the paths for the activity, and the relationship between the conditions.
     * </p>
     * 
     * @return The conditions that define the paths for the activity, and the relationship between the conditions.
     */
    public Condition condition() {
        return condition;
    }

    /**
     * <p>
     * The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon
     * Pinpoint determines whether the conditions are met.
     * </p>
     * 
     * @return The amount of time to wait before determining whether the conditions are met, or the date and time when
     *         Amazon Pinpoint determines whether the conditions are met.
     */
    public WaitTime evaluationWaitTime() {
        return evaluationWaitTime;
    }

    /**
     * <p>
     * The unique identifier for the activity to perform if the conditions aren't met.
     * </p>
     * 
     * @return The unique identifier for the activity to perform if the conditions aren't met.
     */
    public String falseActivity() {
        return falseActivity;
    }

    /**
     * <p>
     * The unique identifier for the activity to perform if the conditions are met.
     * </p>
     * 
     * @return The unique identifier for the activity to perform if the conditions are met.
     */
    public String trueActivity() {
        return trueActivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationWaitTime());
        hashCode = 31 * hashCode + Objects.hashCode(falseActivity());
        hashCode = 31 * hashCode + Objects.hashCode(trueActivity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalSplitActivity)) {
            return false;
        }
        ConditionalSplitActivity other = (ConditionalSplitActivity) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(evaluationWaitTime(), other.evaluationWaitTime())
                && Objects.equals(falseActivity(), other.falseActivity()) && Objects.equals(trueActivity(), other.trueActivity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConditionalSplitActivity").add("Condition", condition())
                .add("EvaluationWaitTime", evaluationWaitTime()).add("FalseActivity", falseActivity())
                .add("TrueActivity", trueActivity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "EvaluationWaitTime":
            return Optional.ofNullable(clazz.cast(evaluationWaitTime()));
        case "FalseActivity":
            return Optional.ofNullable(clazz.cast(falseActivity()));
        case "TrueActivity":
            return Optional.ofNullable(clazz.cast(trueActivity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionalSplitActivity, T> g) {
        return obj -> g.apply((ConditionalSplitActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalSplitActivity> {
        /**
         * <p>
         * The conditions that define the paths for the activity, and the relationship between the conditions.
         * </p>
         * 
         * @param condition
         *        The conditions that define the paths for the activity, and the relationship between the conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Condition condition);

        /**
         * <p>
         * The conditions that define the paths for the activity, and the relationship between the conditions.
         * </p>
         * This is a convenience that creates an instance of the {@link Condition.Builder} avoiding the need to create
         * one manually via {@link Condition#builder()}.
         *
         * When the {@link Consumer} completes, {@link Condition.Builder#build()} is called immediately and its result
         * is passed to {@link #condition(Condition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(Condition)
         */
        default Builder condition(Consumer<Condition.Builder> condition) {
            return condition(Condition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * The amount of time to wait before determining whether the conditions are met, or the date and time when
         * Amazon Pinpoint determines whether the conditions are met.
         * </p>
         * 
         * @param evaluationWaitTime
         *        The amount of time to wait before determining whether the conditions are met, or the date and time
         *        when Amazon Pinpoint determines whether the conditions are met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationWaitTime(WaitTime evaluationWaitTime);

        /**
         * <p>
         * The amount of time to wait before determining whether the conditions are met, or the date and time when
         * Amazon Pinpoint determines whether the conditions are met.
         * </p>
         * This is a convenience that creates an instance of the {@link WaitTime.Builder} avoiding the need to create
         * one manually via {@link WaitTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link WaitTime.Builder#build()} is called immediately and its result is
         * passed to {@link #evaluationWaitTime(WaitTime)}.
         * 
         * @param evaluationWaitTime
         *        a consumer that will call methods on {@link WaitTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationWaitTime(WaitTime)
         */
        default Builder evaluationWaitTime(Consumer<WaitTime.Builder> evaluationWaitTime) {
            return evaluationWaitTime(WaitTime.builder().applyMutation(evaluationWaitTime).build());
        }

        /**
         * <p>
         * The unique identifier for the activity to perform if the conditions aren't met.
         * </p>
         * 
         * @param falseActivity
         *        The unique identifier for the activity to perform if the conditions aren't met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder falseActivity(String falseActivity);

        /**
         * <p>
         * The unique identifier for the activity to perform if the conditions are met.
         * </p>
         * 
         * @param trueActivity
         *        The unique identifier for the activity to perform if the conditions are met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trueActivity(String trueActivity);
    }

    static final class BuilderImpl implements Builder {
        private Condition condition;

        private WaitTime evaluationWaitTime;

        private String falseActivity;

        private String trueActivity;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalSplitActivity model) {
            condition(model.condition);
            evaluationWaitTime(model.evaluationWaitTime);
            falseActivity(model.falseActivity);
            trueActivity(model.trueActivity);
        }

        public final Condition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        public final WaitTime.Builder getEvaluationWaitTime() {
            return evaluationWaitTime != null ? evaluationWaitTime.toBuilder() : null;
        }

        @Override
        public final Builder evaluationWaitTime(WaitTime evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime;
            return this;
        }

        public final void setEvaluationWaitTime(WaitTime.BuilderImpl evaluationWaitTime) {
            this.evaluationWaitTime = evaluationWaitTime != null ? evaluationWaitTime.build() : null;
        }

        public final String getFalseActivity() {
            return falseActivity;
        }

        @Override
        public final Builder falseActivity(String falseActivity) {
            this.falseActivity = falseActivity;
            return this;
        }

        public final void setFalseActivity(String falseActivity) {
            this.falseActivity = falseActivity;
        }

        public final String getTrueActivity() {
            return trueActivity;
        }

        @Override
        public final Builder trueActivity(String trueActivity) {
            this.trueActivity = trueActivity;
            return this;
        }

        public final void setTrueActivity(String trueActivity) {
            this.trueActivity = trueActivity;
        }

        @Override
        public ConditionalSplitActivity build() {
            return new ConditionalSplitActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
